/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolDescriptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserPoolsResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, ListUserPoolsResponse> {
    private static final SdkField<List<UserPoolDescriptionType>> USER_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserPools").getter(ListUserPoolsResponse.getter(ListUserPoolsResponse::userPools)).setter(ListUserPoolsResponse.setter(Builder::userPools)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserPoolDescriptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserPoolsResponse.getter(ListUserPoolsResponse::nextToken)).setter(ListUserPoolsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOLS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserPools", USER_POOLS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<UserPoolDescriptionType> userPools;
    private final String nextToken;

    private ListUserPoolsResponse(BuilderImpl builder) {
        super(builder);
        this.userPools = builder.userPools;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserPools() {
        return this.userPools != null && !(this.userPools instanceof SdkAutoConstructList);
    }

    public final List<UserPoolDescriptionType> userPools() {
        return this.userPools;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserPools() ? this.userPools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserPoolsResponse)) {
            return false;
        }
        ListUserPoolsResponse other = (ListUserPoolsResponse)((Object)obj);
        return this.hasUserPools() == other.hasUserPools() && Objects.equals(this.userPools(), other.userPools()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserPoolsResponse").add("UserPools", this.hasUserPools() ? this.userPools() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPools": {
                return Optional.ofNullable(clazz.cast(this.userPools()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListUserPoolsResponse, T> g) {
        return obj -> g.apply((ListUserPoolsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private List<UserPoolDescriptionType> userPools = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserPoolsResponse model) {
            super(model);
            this.userPools(model.userPools);
            this.nextToken(model.nextToken);
        }

        public final List<UserPoolDescriptionType.Builder> getUserPools() {
            List<UserPoolDescriptionType.Builder> result = UserPoolListTypeCopier.copyToBuilder(this.userPools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserPools(Collection<UserPoolDescriptionType.BuilderImpl> userPools) {
            this.userPools = UserPoolListTypeCopier.copyFromBuilder(userPools);
        }

        @Override
        public final Builder userPools(Collection<UserPoolDescriptionType> userPools) {
            this.userPools = UserPoolListTypeCopier.copy(userPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPools(UserPoolDescriptionType ... userPools) {
            this.userPools(Arrays.asList(userPools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userPools(Consumer<UserPoolDescriptionType.Builder> ... userPools) {
            this.userPools(Stream.of(userPools).map(c -> (UserPoolDescriptionType)((UserPoolDescriptionType.Builder)UserPoolDescriptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUserPoolsResponse build() {
            return new ListUserPoolsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserPoolsResponse> {
        public Builder userPools(Collection<UserPoolDescriptionType> var1);

        public Builder userPools(UserPoolDescriptionType ... var1);

        public Builder userPools(Consumer<UserPoolDescriptionType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

