/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the response from the server for the request to update user attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserAttributesResponse extends CognitoIdentityProviderResponse implements
        ToCopyableBuilder<UpdateUserAttributesResponse.Builder, UpdateUserAttributesResponse> {
    private static final SdkField<List<CodeDeliveryDetailsType>> CODE_DELIVERY_DETAILS_LIST_FIELD = SdkField
            .<List<CodeDeliveryDetailsType>> builder(MarshallingType.LIST)
            .memberName("CodeDeliveryDetailsList")
            .getter(getter(UpdateUserAttributesResponse::codeDeliveryDetailsList))
            .setter(setter(Builder::codeDeliveryDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeliveryDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeDeliveryDetailsType> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeDeliveryDetailsType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CODE_DELIVERY_DETAILS_LIST_FIELD));

    private final List<CodeDeliveryDetailsType> codeDeliveryDetailsList;

    private UpdateUserAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.codeDeliveryDetailsList = builder.codeDeliveryDetailsList;
    }

    /**
     * Returns true if the CodeDeliveryDetailsList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCodeDeliveryDetailsList() {
        return codeDeliveryDetailsList != null && !(codeDeliveryDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The code delivery details list from the server for the request to update user attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodeDeliveryDetailsList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The code delivery details list from the server for the request to update user attributes.
     */
    public final List<CodeDeliveryDetailsType> codeDeliveryDetailsList() {
        return codeDeliveryDetailsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCodeDeliveryDetailsList() ? codeDeliveryDetailsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserAttributesResponse)) {
            return false;
        }
        UpdateUserAttributesResponse other = (UpdateUserAttributesResponse) obj;
        return hasCodeDeliveryDetailsList() == other.hasCodeDeliveryDetailsList()
                && Objects.equals(codeDeliveryDetailsList(), other.codeDeliveryDetailsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserAttributesResponse")
                .add("CodeDeliveryDetailsList", hasCodeDeliveryDetailsList() ? codeDeliveryDetailsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeDeliveryDetailsList":
            return Optional.ofNullable(clazz.cast(codeDeliveryDetailsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserAttributesResponse, T> g) {
        return obj -> g.apply((UpdateUserAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityProviderResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserAttributesResponse> {
        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * 
         * @param codeDeliveryDetailsList
         *        The code delivery details list from the server for the request to update user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> codeDeliveryDetailsList);

        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * 
         * @param codeDeliveryDetailsList
         *        The code delivery details list from the server for the request to update user attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeDeliveryDetailsList(CodeDeliveryDetailsType... codeDeliveryDetailsList);

        /**
         * <p>
         * The code delivery details list from the server for the request to update user attributes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CodeDeliveryDetailsType>.Builder} avoiding
         * the need to create one manually via {@link List<CodeDeliveryDetailsType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeDeliveryDetailsType>.Builder#build()} is called
         * immediately and its result is passed to {@link #codeDeliveryDetailsList(List<CodeDeliveryDetailsType>)}.
         * 
         * @param codeDeliveryDetailsList
         *        a consumer that will call methods on {@link List<CodeDeliveryDetailsType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeDeliveryDetailsList(List<CodeDeliveryDetailsType>)
         */
        Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder>... codeDeliveryDetailsList);
    }

    static final class BuilderImpl extends CognitoIdentityProviderResponse.BuilderImpl implements Builder {
        private List<CodeDeliveryDetailsType> codeDeliveryDetailsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserAttributesResponse model) {
            super(model);
            codeDeliveryDetailsList(model.codeDeliveryDetailsList);
        }

        public final Collection<CodeDeliveryDetailsType.Builder> getCodeDeliveryDetailsList() {
            if (codeDeliveryDetailsList instanceof SdkAutoConstructList) {
                return null;
            }
            return codeDeliveryDetailsList != null ? codeDeliveryDetailsList.stream().map(CodeDeliveryDetailsType::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeDeliveryDetailsList(Collection<CodeDeliveryDetailsType> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copy(codeDeliveryDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(CodeDeliveryDetailsType... codeDeliveryDetailsList) {
            codeDeliveryDetailsList(Arrays.asList(codeDeliveryDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeDeliveryDetailsList(Consumer<CodeDeliveryDetailsType.Builder>... codeDeliveryDetailsList) {
            codeDeliveryDetailsList(Stream.of(codeDeliveryDetailsList)
                    .map(c -> CodeDeliveryDetailsType.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCodeDeliveryDetailsList(Collection<CodeDeliveryDetailsType.BuilderImpl> codeDeliveryDetailsList) {
            this.codeDeliveryDetailsList = CodeDeliveryDetailsListTypeCopier.copyFromBuilder(codeDeliveryDetailsList);
        }

        @Override
        public UpdateUserAttributesResponse build() {
            return new UpdateUserAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
