/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareTokenMfaSettingsType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareTokenMfaSettingsType> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SoftwareTokenMfaSettingsType.getter(SoftwareTokenMfaSettingsType::enabled)).setter(SoftwareTokenMfaSettingsType.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> PREFERRED_MFA_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(SoftwareTokenMfaSettingsType.getter(SoftwareTokenMfaSettingsType::preferredMfa)).setter(SoftwareTokenMfaSettingsType.setter(Builder::preferredMfa)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfa").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, PREFERRED_MFA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Boolean preferredMfa;

    private SoftwareTokenMfaSettingsType(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.preferredMfa = builder.preferredMfa;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Boolean preferredMfa() {
        return this.preferredMfa;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMfa());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareTokenMfaSettingsType)) {
            return false;
        }
        SoftwareTokenMfaSettingsType other = (SoftwareTokenMfaSettingsType)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.preferredMfa(), other.preferredMfa());
    }

    public String toString() {
        return ToString.builder((String)"SoftwareTokenMfaSettingsType").add("Enabled", (Object)this.enabled()).add("PreferredMfa", (Object)this.preferredMfa()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "PreferredMfa": {
                return Optional.ofNullable(clazz.cast(this.preferredMfa()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareTokenMfaSettingsType, T> g) {
        return obj -> g.apply((SoftwareTokenMfaSettingsType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Boolean preferredMfa;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareTokenMfaSettingsType model) {
            this.enabled(model.enabled);
            this.preferredMfa(model.preferredMfa);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getPreferredMfa() {
            return this.preferredMfa;
        }

        @Override
        public final Builder preferredMfa(Boolean preferredMfa) {
            this.preferredMfa = preferredMfa;
            return this;
        }

        public final void setPreferredMfa(Boolean preferredMfa) {
            this.preferredMfa = preferredMfa;
        }

        public SoftwareTokenMfaSettingsType build() {
            return new SoftwareTokenMfaSettingsType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareTokenMfaSettingsType> {
        public Builder enabled(Boolean var1);

        public Builder preferredMfa(Boolean var1);
    }
}

