/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AttributeDataType {
    STRING("String"),
    NUMBER("Number"),
    DATE_TIME("DateTime"),
    BOOLEAN("Boolean"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AttributeDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AttributeDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AttributeDataType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AttributeDataType> knownValues() {
        return Stream.of(AttributeDataType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

