/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceConfigurationType> {
    private static final SdkField<Boolean> CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeviceConfigurationType.getter(DeviceConfigurationType::challengeRequiredOnNewDevice)).setter(DeviceConfigurationType.setter(Builder::challengeRequiredOnNewDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeRequiredOnNewDevice").build()}).build();
    private static final SdkField<Boolean> DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DeviceConfigurationType.getter(DeviceConfigurationType::deviceOnlyRememberedOnUserPrompt)).setter(DeviceConfigurationType.setter(Builder::deviceOnlyRememberedOnUserPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceOnlyRememberedOnUserPrompt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_REQUIRED_ON_NEW_DEVICE_FIELD, DEVICE_ONLY_REMEMBERED_ON_USER_PROMPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean challengeRequiredOnNewDevice;
    private final Boolean deviceOnlyRememberedOnUserPrompt;

    private DeviceConfigurationType(BuilderImpl builder) {
        this.challengeRequiredOnNewDevice = builder.challengeRequiredOnNewDevice;
        this.deviceOnlyRememberedOnUserPrompt = builder.deviceOnlyRememberedOnUserPrompt;
    }

    public Boolean challengeRequiredOnNewDevice() {
        return this.challengeRequiredOnNewDevice;
    }

    public Boolean deviceOnlyRememberedOnUserPrompt() {
        return this.deviceOnlyRememberedOnUserPrompt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeRequiredOnNewDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceOnlyRememberedOnUserPrompt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceConfigurationType)) {
            return false;
        }
        DeviceConfigurationType other = (DeviceConfigurationType)obj;
        return Objects.equals(this.challengeRequiredOnNewDevice(), other.challengeRequiredOnNewDevice()) && Objects.equals(this.deviceOnlyRememberedOnUserPrompt(), other.deviceOnlyRememberedOnUserPrompt());
    }

    public String toString() {
        return ToString.builder((String)"DeviceConfigurationType").add("ChallengeRequiredOnNewDevice", (Object)this.challengeRequiredOnNewDevice()).add("DeviceOnlyRememberedOnUserPrompt", (Object)this.deviceOnlyRememberedOnUserPrompt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeRequiredOnNewDevice": {
                return Optional.ofNullable(clazz.cast(this.challengeRequiredOnNewDevice()));
            }
            case "DeviceOnlyRememberedOnUserPrompt": {
                return Optional.ofNullable(clazz.cast(this.deviceOnlyRememberedOnUserPrompt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceConfigurationType, T> g) {
        return obj -> g.apply((DeviceConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean challengeRequiredOnNewDevice;
        private Boolean deviceOnlyRememberedOnUserPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceConfigurationType model) {
            this.challengeRequiredOnNewDevice(model.challengeRequiredOnNewDevice);
            this.deviceOnlyRememberedOnUserPrompt(model.deviceOnlyRememberedOnUserPrompt);
        }

        public final Boolean getChallengeRequiredOnNewDevice() {
            return this.challengeRequiredOnNewDevice;
        }

        @Override
        public final Builder challengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        public final void setChallengeRequiredOnNewDevice(Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
        }

        public final Boolean getDeviceOnlyRememberedOnUserPrompt() {
            return this.deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        public final Builder deviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        public final void setDeviceOnlyRememberedOnUserPrompt(Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
        }

        public DeviceConfigurationType build() {
            return new DeviceConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceConfigurationType> {
        public Builder challengeRequiredOnNewDevice(Boolean var1);

        public Builder deviceOnlyRememberedOnUserPrompt(Boolean var1);
    }
}

