/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.PrincipalTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPrincipalTagAttributeMapResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, GetPrincipalTagAttributeMapResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(GetPrincipalTagAttributeMapResponse.getter(GetPrincipalTagAttributeMapResponse::identityPoolId)).setter(GetPrincipalTagAttributeMapResponse.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityProviderName").getter(GetPrincipalTagAttributeMapResponse.getter(GetPrincipalTagAttributeMapResponse::identityProviderName)).setter(GetPrincipalTagAttributeMapResponse.setter(Builder::identityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderName").build()}).build();
    private static final SdkField<Boolean> USE_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseDefaults").getter(GetPrincipalTagAttributeMapResponse.getter(GetPrincipalTagAttributeMapResponse::useDefaults)).setter(GetPrincipalTagAttributeMapResponse.setter(Builder::useDefaults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaults").build()}).build();
    private static final SdkField<Map<String, String>> PRINCIPAL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PrincipalTags").getter(GetPrincipalTagAttributeMapResponse.getter(GetPrincipalTagAttributeMapResponse::principalTags)).setter(GetPrincipalTagAttributeMapResponse.setter(Builder::principalTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITY_PROVIDER_NAME_FIELD, USE_DEFAULTS_FIELD, PRINCIPAL_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPrincipalTagAttributeMapResponse.memberNameToFieldInitializer();
    private final String identityPoolId;
    private final String identityProviderName;
    private final Boolean useDefaults;
    private final Map<String, String> principalTags;

    private GetPrincipalTagAttributeMapResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityProviderName = builder.identityProviderName;
        this.useDefaults = builder.useDefaults;
        this.principalTags = builder.principalTags;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String identityProviderName() {
        return this.identityProviderName;
    }

    public final Boolean useDefaults() {
        return this.useDefaults;
    }

    public final boolean hasPrincipalTags() {
        return this.principalTags != null && !(this.principalTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> principalTags() {
        return this.principalTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipalTags() ? this.principalTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPrincipalTagAttributeMapResponse)) {
            return false;
        }
        GetPrincipalTagAttributeMapResponse other = (GetPrincipalTagAttributeMapResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityProviderName(), other.identityProviderName()) && Objects.equals(this.useDefaults(), other.useDefaults()) && this.hasPrincipalTags() == other.hasPrincipalTags() && Objects.equals(this.principalTags(), other.principalTags());
    }

    public final String toString() {
        return ToString.builder((String)"GetPrincipalTagAttributeMapResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityProviderName", (Object)this.identityProviderName()).add("UseDefaults", (Object)this.useDefaults()).add("PrincipalTags", this.hasPrincipalTags() ? this.principalTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityProviderName": {
                return Optional.ofNullable(clazz.cast(this.identityProviderName()));
            }
            case "UseDefaults": {
                return Optional.ofNullable(clazz.cast(this.useDefaults()));
            }
            case "PrincipalTags": {
                return Optional.ofNullable(clazz.cast(this.principalTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("IdentityProviderName", IDENTITY_PROVIDER_NAME_FIELD);
        map.put("UseDefaults", USE_DEFAULTS_FIELD);
        map.put("PrincipalTags", PRINCIPAL_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPrincipalTagAttributeMapResponse, T> g) {
        return obj -> g.apply((GetPrincipalTagAttributeMapResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityProviderName;
        private Boolean useDefaults;
        private Map<String, String> principalTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPrincipalTagAttributeMapResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityProviderName(model.identityProviderName);
            this.useDefaults(model.useDefaults);
            this.principalTags(model.principalTags);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityProviderName() {
            return this.identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final Boolean getUseDefaults() {
            return this.useDefaults;
        }

        public final void setUseDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
        }

        @Override
        public final Builder useDefaults(Boolean useDefaults) {
            this.useDefaults = useDefaults;
            return this;
        }

        public final Map<String, String> getPrincipalTags() {
            if (this.principalTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.principalTags;
        }

        public final void setPrincipalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
        }

        @Override
        public final Builder principalTags(Map<String, String> principalTags) {
            this.principalTags = PrincipalTagsCopier.copy(principalTags);
            return this;
        }

        @Override
        public GetPrincipalTagAttributeMapResponse build() {
            return new GetPrincipalTagAttributeMapResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPrincipalTagAttributeMapResponse> {
        public Builder identityPoolId(String var1);

        public Builder identityProviderName(String var1);

        public Builder useDefaults(Boolean var1);

        public Builder principalTags(Map<String, String> var1);
    }
}

