/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolTagsTypeCopier;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityProvidersCopier;
import software.amazon.awssdk.services.cognitoidentity.model.OIDCProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.SAMLProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdentityPoolRequest
extends CognitoIdentityRequest
implements ToCopyableBuilder<Builder, UpdateIdentityPoolRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::identityPoolId)).setter(UpdateIdentityPoolRequest.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<String> IDENTITY_POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolName").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::identityPoolName)).setter(UpdateIdentityPoolRequest.setter(Builder::identityPoolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolName").build()}).build();
    private static final SdkField<Boolean> ALLOW_UNAUTHENTICATED_IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowUnauthenticatedIdentities").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::allowUnauthenticatedIdentities)).setter(UpdateIdentityPoolRequest.setter(Builder::allowUnauthenticatedIdentities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnauthenticatedIdentities").build()}).build();
    private static final SdkField<Boolean> ALLOW_CLASSIC_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowClassicFlow").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::allowClassicFlow)).setter(UpdateIdentityPoolRequest.setter(Builder::allowClassicFlow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowClassicFlow").build()}).build();
    private static final SdkField<Map<String, String>> SUPPORTED_LOGIN_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SupportedLoginProviders").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::supportedLoginProviders)).setter(UpdateIdentityPoolRequest.setter(Builder::supportedLoginProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedLoginProviders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DEVELOPER_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeveloperProviderName").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::developerProviderName)).setter(UpdateIdentityPoolRequest.setter(Builder::developerProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperProviderName").build()}).build();
    private static final SdkField<List<String>> OPEN_ID_CONNECT_PROVIDER_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OpenIdConnectProviderARNs").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::openIdConnectProviderARNs)).setter(UpdateIdentityPoolRequest.setter(Builder::openIdConnectProviderARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConnectProviderARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CognitoIdentityProvider>> COGNITO_IDENTITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CognitoIdentityProviders").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::cognitoIdentityProviders)).setter(UpdateIdentityPoolRequest.setter(Builder::cognitoIdentityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoIdentityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CognitoIdentityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SAML_PROVIDER_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SamlProviderARNs").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::samlProviderARNs)).setter(UpdateIdentityPoolRequest.setter(Builder::samlProviderARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlProviderARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> IDENTITY_POOL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IdentityPoolTags").getter(UpdateIdentityPoolRequest.getter(UpdateIdentityPoolRequest::identityPoolTags)).setter(UpdateIdentityPoolRequest.setter(Builder::identityPoolTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITY_POOL_NAME_FIELD, ALLOW_UNAUTHENTICATED_IDENTITIES_FIELD, ALLOW_CLASSIC_FLOW_FIELD, SUPPORTED_LOGIN_PROVIDERS_FIELD, DEVELOPER_PROVIDER_NAME_FIELD, OPEN_ID_CONNECT_PROVIDER_AR_NS_FIELD, COGNITO_IDENTITY_PROVIDERS_FIELD, SAML_PROVIDER_AR_NS_FIELD, IDENTITY_POOL_TAGS_FIELD));
    private final String identityPoolId;
    private final String identityPoolName;
    private final Boolean allowUnauthenticatedIdentities;
    private final Boolean allowClassicFlow;
    private final Map<String, String> supportedLoginProviders;
    private final String developerProviderName;
    private final List<String> openIdConnectProviderARNs;
    private final List<CognitoIdentityProvider> cognitoIdentityProviders;
    private final List<String> samlProviderARNs;
    private final Map<String, String> identityPoolTags;

    private UpdateIdentityPoolRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
        this.allowUnauthenticatedIdentities = builder.allowUnauthenticatedIdentities;
        this.allowClassicFlow = builder.allowClassicFlow;
        this.supportedLoginProviders = builder.supportedLoginProviders;
        this.developerProviderName = builder.developerProviderName;
        this.openIdConnectProviderARNs = builder.openIdConnectProviderARNs;
        this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
        this.samlProviderARNs = builder.samlProviderARNs;
        this.identityPoolTags = builder.identityPoolTags;
    }

    public final String identityPoolId() {
        return this.identityPoolId;
    }

    public final String identityPoolName() {
        return this.identityPoolName;
    }

    public final Boolean allowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public final Boolean allowClassicFlow() {
        return this.allowClassicFlow;
    }

    public final boolean hasSupportedLoginProviders() {
        return this.supportedLoginProviders != null && !(this.supportedLoginProviders instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> supportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public final String developerProviderName() {
        return this.developerProviderName;
    }

    public final boolean hasOpenIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs != null && !(this.openIdConnectProviderARNs instanceof SdkAutoConstructList);
    }

    public final List<String> openIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public final boolean hasCognitoIdentityProviders() {
        return this.cognitoIdentityProviders != null && !(this.cognitoIdentityProviders instanceof SdkAutoConstructList);
    }

    public final List<CognitoIdentityProvider> cognitoIdentityProviders() {
        return this.cognitoIdentityProviders;
    }

    public final boolean hasSamlProviderARNs() {
        return this.samlProviderARNs != null && !(this.samlProviderARNs instanceof SdkAutoConstructList);
    }

    public final List<String> samlProviderARNs() {
        return this.samlProviderARNs;
    }

    public final boolean hasIdentityPoolTags() {
        return this.identityPoolTags != null && !(this.identityPoolTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> identityPoolTags() {
        return this.identityPoolTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnauthenticatedIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowClassicFlow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedLoginProviders() ? this.supportedLoginProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOpenIdConnectProviderARNs() ? this.openIdConnectProviderARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCognitoIdentityProviders() ? this.cognitoIdentityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamlProviderARNs() ? this.samlProviderARNs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityPoolTags() ? this.identityPoolTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolRequest)) {
            return false;
        }
        UpdateIdentityPoolRequest other = (UpdateIdentityPoolRequest)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityPoolName(), other.identityPoolName()) && Objects.equals(this.allowUnauthenticatedIdentities(), other.allowUnauthenticatedIdentities()) && Objects.equals(this.allowClassicFlow(), other.allowClassicFlow()) && this.hasSupportedLoginProviders() == other.hasSupportedLoginProviders() && Objects.equals(this.supportedLoginProviders(), other.supportedLoginProviders()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && this.hasOpenIdConnectProviderARNs() == other.hasOpenIdConnectProviderARNs() && Objects.equals(this.openIdConnectProviderARNs(), other.openIdConnectProviderARNs()) && this.hasCognitoIdentityProviders() == other.hasCognitoIdentityProviders() && Objects.equals(this.cognitoIdentityProviders(), other.cognitoIdentityProviders()) && this.hasSamlProviderARNs() == other.hasSamlProviderARNs() && Objects.equals(this.samlProviderARNs(), other.samlProviderARNs()) && this.hasIdentityPoolTags() == other.hasIdentityPoolTags() && Objects.equals(this.identityPoolTags(), other.identityPoolTags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIdentityPoolRequest").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityPoolName", (Object)this.identityPoolName()).add("AllowUnauthenticatedIdentities", (Object)this.allowUnauthenticatedIdentities()).add("AllowClassicFlow", (Object)this.allowClassicFlow()).add("SupportedLoginProviders", this.hasSupportedLoginProviders() ? this.supportedLoginProviders() : null).add("DeveloperProviderName", (Object)this.developerProviderName()).add("OpenIdConnectProviderARNs", this.hasOpenIdConnectProviderARNs() ? this.openIdConnectProviderARNs() : null).add("CognitoIdentityProviders", this.hasCognitoIdentityProviders() ? this.cognitoIdentityProviders() : null).add("SamlProviderARNs", this.hasSamlProviderARNs() ? this.samlProviderARNs() : null).add("IdentityPoolTags", this.hasIdentityPoolTags() ? this.identityPoolTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityPoolName": {
                return Optional.ofNullable(clazz.cast(this.identityPoolName()));
            }
            case "AllowUnauthenticatedIdentities": {
                return Optional.ofNullable(clazz.cast(this.allowUnauthenticatedIdentities()));
            }
            case "AllowClassicFlow": {
                return Optional.ofNullable(clazz.cast(this.allowClassicFlow()));
            }
            case "SupportedLoginProviders": {
                return Optional.ofNullable(clazz.cast(this.supportedLoginProviders()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "OpenIdConnectProviderARNs": {
                return Optional.ofNullable(clazz.cast(this.openIdConnectProviderARNs()));
            }
            case "CognitoIdentityProviders": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityProviders()));
            }
            case "SamlProviderARNs": {
                return Optional.ofNullable(clazz.cast(this.samlProviderARNs()));
            }
            case "IdentityPoolTags": {
                return Optional.ofNullable(clazz.cast(this.identityPoolTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentityPoolRequest, T> g) {
        return obj -> g.apply((UpdateIdentityPoolRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityRequest.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityPoolName;
        private Boolean allowUnauthenticatedIdentities;
        private Boolean allowClassicFlow;
        private Map<String, String> supportedLoginProviders = DefaultSdkAutoConstructMap.getInstance();
        private String developerProviderName;
        private List<String> openIdConnectProviderARNs = DefaultSdkAutoConstructList.getInstance();
        private List<CognitoIdentityProvider> cognitoIdentityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> samlProviderARNs = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> identityPoolTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityPoolRequest model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityPoolName(model.identityPoolName);
            this.allowUnauthenticatedIdentities(model.allowUnauthenticatedIdentities);
            this.allowClassicFlow(model.allowClassicFlow);
            this.supportedLoginProviders(model.supportedLoginProviders);
            this.developerProviderName(model.developerProviderName);
            this.openIdConnectProviderARNs(model.openIdConnectProviderARNs);
            this.cognitoIdentityProviders(model.cognitoIdentityProviders);
            this.samlProviderARNs(model.samlProviderARNs);
            this.identityPoolTags(model.identityPoolTags);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return this.identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        public final Boolean getAllowUnauthenticatedIdentities() {
            return this.allowUnauthenticatedIdentities;
        }

        @Override
        public final Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        public final void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        }

        public final Boolean getAllowClassicFlow() {
            return this.allowClassicFlow;
        }

        @Override
        public final Builder allowClassicFlow(Boolean allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
            return this;
        }

        public final void setAllowClassicFlow(Boolean allowClassicFlow) {
            this.allowClassicFlow = allowClassicFlow;
        }

        public final Map<String, String> getSupportedLoginProviders() {
            if (this.supportedLoginProviders instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.supportedLoginProviders;
        }

        @Override
        public final Builder supportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
            return this;
        }

        public final void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final Collection<String> getOpenIdConnectProviderARNs() {
            if (this.openIdConnectProviderARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.openIdConnectProviderARNs;
        }

        @Override
        public final Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
            return this;
        }

        public final void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
        }

        public final List<CognitoIdentityProvider.Builder> getCognitoIdentityProviders() {
            List<CognitoIdentityProvider.Builder> result = CognitoIdentityProviderListCopier.copyToBuilder(this.cognitoIdentityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder> ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Stream.of(cognitoIdentityProviders).map(c -> (CognitoIdentityProvider)((CognitoIdentityProvider.Builder)CognitoIdentityProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCognitoIdentityProviders(Collection<CognitoIdentityProvider.BuilderImpl> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copyFromBuilder(cognitoIdentityProviders);
        }

        public final Collection<String> getSamlProviderARNs() {
            if (this.samlProviderARNs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.samlProviderARNs;
        }

        @Override
        public final Builder samlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderARNs(String ... samlProviderARNs) {
            this.samlProviderARNs(Arrays.asList(samlProviderARNs));
            return this;
        }

        public final void setSamlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
        }

        public final Map<String, String> getIdentityPoolTags() {
            if (this.identityPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identityPoolTags;
        }

        @Override
        public final Builder identityPoolTags(Map<String, String> identityPoolTags) {
            this.identityPoolTags = IdentityPoolTagsTypeCopier.copy(identityPoolTags);
            return this;
        }

        public final void setIdentityPoolTags(Map<String, String> identityPoolTags) {
            this.identityPoolTags = IdentityPoolTagsTypeCopier.copy(identityPoolTags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdentityPoolRequest build() {
            return new UpdateIdentityPoolRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIdentityPoolRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityPoolName(String var1);

        public Builder allowUnauthenticatedIdentities(Boolean var1);

        public Builder allowClassicFlow(Boolean var1);

        public Builder supportedLoginProviders(Map<String, String> var1);

        public Builder developerProviderName(String var1);

        public Builder openIdConnectProviderARNs(Collection<String> var1);

        public Builder openIdConnectProviderARNs(String ... var1);

        public Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> var1);

        public Builder cognitoIdentityProviders(CognitoIdentityProvider ... var1);

        public Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder> ... var1);

        public Builder samlProviderARNs(Collection<String> var1);

        public Builder samlProviderARNs(String ... var1);

        public Builder identityPoolTags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

