/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.IdentitiesListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentitiesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, ListIdentitiesResponse> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityPoolId").getter(ListIdentitiesResponse.getter(ListIdentitiesResponse::identityPoolId)).setter(ListIdentitiesResponse.setter(Builder::identityPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()}).build();
    private static final SdkField<List<IdentityDescription>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identities").getter(ListIdentitiesResponse.getter(ListIdentitiesResponse::identities)).setter(ListIdentitiesResponse.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentitiesResponse.getter(ListIdentitiesResponse::nextToken)).setter(ListIdentitiesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD, IDENTITIES_FIELD, NEXT_TOKEN_FIELD));
    private final String identityPoolId;
    private final List<IdentityDescription> identities;
    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructList);
    }

    public List<IdentityDescription> identities() {
        return this.identities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentitiesResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("Identities", this.hasIdentities() ? this.identities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentitiesResponse, T> g) {
        return obj -> g.apply((ListIdentitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private List<IdentityDescription> identities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identities(model.identities);
            this.nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Collection<IdentityDescription.Builder> getIdentities() {
            if (this.identities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identities != null ? (Collection)this.identities.stream().map(IdentityDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identities(Collection<IdentityDescription> identities) {
            this.identities = IdentitiesListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(IdentityDescription ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(Consumer<IdentityDescription.Builder> ... identities) {
            this.identities(Stream.of(identities).map(c -> (IdentityDescription)((IdentityDescription.Builder)IdentityDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIdentities(Collection<IdentityDescription.BuilderImpl> identities) {
            this.identities = IdentitiesListCopier.copyFromBuilder(identities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentitiesResponse> {
        public Builder identityPoolId(String var1);

        public Builder identities(Collection<IdentityDescription> var1);

        public Builder identities(IdentityDescription ... var1);

        public Builder identities(Consumer<IdentityDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

