/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input to the <code>UnlinkDeveloperIdentity</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnlinkDeveloperIdentityRequest extends CognitoIdentityRequest implements
        ToCopyableBuilder<UnlinkDeveloperIdentityRequest.Builder, UnlinkDeveloperIdentityRequest> {
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnlinkDeveloperIdentityRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()).build();

    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnlinkDeveloperIdentityRequest::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> DEVELOPER_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnlinkDeveloperIdentityRequest::developerProviderName)).setter(setter(Builder::developerProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperProviderName").build())
            .build();

    private static final SdkField<String> DEVELOPER_USER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UnlinkDeveloperIdentityRequest::developerUserIdentifier))
            .setter(setter(Builder::developerUserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeveloperUserIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ID_FIELD,
            IDENTITY_POOL_ID_FIELD, DEVELOPER_PROVIDER_NAME_FIELD, DEVELOPER_USER_IDENTIFIER_FIELD));

    private final String identityId;

    private final String identityPoolId;

    private final String developerProviderName;

    private final String developerUserIdentifier;

    private UnlinkDeveloperIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.identityPoolId = builder.identityPoolId;
        this.developerProviderName = builder.developerProviderName;
        this.developerUserIdentifier = builder.developerUserIdentifier;
    }

    /**
     * <p>
     * A unique identifier in the format REGION:GUID.
     * </p>
     * 
     * @return A unique identifier in the format REGION:GUID.
     */
    public String identityId() {
        return identityId;
    }

    /**
     * <p>
     * An identity pool ID in the format REGION:GUID.
     * </p>
     * 
     * @return An identity pool ID in the format REGION:GUID.
     */
    public String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * The "domain" by which Cognito will refer to your users.
     * </p>
     * 
     * @return The "domain" by which Cognito will refer to your users.
     */
    public String developerProviderName() {
        return developerProviderName;
    }

    /**
     * <p>
     * A unique ID used by your backend authentication process to identify a user.
     * </p>
     * 
     * @return A unique ID used by your backend authentication process to identify a user.
     */
    public String developerUserIdentifier() {
        return developerUserIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(developerUserIdentifier());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnlinkDeveloperIdentityRequest)) {
            return false;
        }
        UnlinkDeveloperIdentityRequest other = (UnlinkDeveloperIdentityRequest) obj;
        return Objects.equals(identityId(), other.identityId()) && Objects.equals(identityPoolId(), other.identityPoolId())
                && Objects.equals(developerProviderName(), other.developerProviderName())
                && Objects.equals(developerUserIdentifier(), other.developerUserIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UnlinkDeveloperIdentityRequest").add("IdentityId", identityId())
                .add("IdentityPoolId", identityPoolId()).add("DeveloperProviderName", developerProviderName())
                .add("DeveloperUserIdentifier", developerUserIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "DeveloperProviderName":
            return Optional.ofNullable(clazz.cast(developerProviderName()));
        case "DeveloperUserIdentifier":
            return Optional.ofNullable(clazz.cast(developerUserIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnlinkDeveloperIdentityRequest, T> g) {
        return obj -> g.apply((UnlinkDeveloperIdentityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CognitoIdentityRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UnlinkDeveloperIdentityRequest> {
        /**
         * <p>
         * A unique identifier in the format REGION:GUID.
         * </p>
         * 
         * @param identityId
         *        A unique identifier in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * <p>
         * An identity pool ID in the format REGION:GUID.
         * </p>
         * 
         * @param identityPoolId
         *        An identity pool ID in the format REGION:GUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * The "domain" by which Cognito will refer to your users.
         * </p>
         * 
         * @param developerProviderName
         *        The "domain" by which Cognito will refer to your users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerProviderName(String developerProviderName);

        /**
         * <p>
         * A unique ID used by your backend authentication process to identify a user.
         * </p>
         * 
         * @param developerUserIdentifier
         *        A unique ID used by your backend authentication process to identify a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder developerUserIdentifier(String developerUserIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoIdentityRequest.BuilderImpl implements Builder {
        private String identityId;

        private String identityPoolId;

        private String developerProviderName;

        private String developerUserIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UnlinkDeveloperIdentityRequest model) {
            super(model);
            identityId(model.identityId);
            identityPoolId(model.identityPoolId);
            developerProviderName(model.developerProviderName);
            developerUserIdentifier(model.developerUserIdentifier);
        }

        public final String getIdentityId() {
            return identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getDeveloperProviderName() {
            return developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getDeveloperUserIdentifier() {
            return developerUserIdentifier;
        }

        @Override
        public final Builder developerUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
            return this;
        }

        public final void setDeveloperUserIdentifier(String developerUserIdentifier) {
            this.developerUserIdentifier = developerUserIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UnlinkDeveloperIdentityRequest build() {
            return new UnlinkDeveloperIdentityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
