/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityProvidersCopier;
import software.amazon.awssdk.services.cognitoidentity.model.OIDCProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.SAMLProviderListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateIdentityPoolRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateIdentityPoolRequest> {
    private final String identityPoolId;
    private final String identityPoolName;
    private final Boolean allowUnauthenticatedIdentities;
    private final Map<String, String> supportedLoginProviders;
    private final String developerProviderName;
    private final List<String> openIdConnectProviderARNs;
    private final List<CognitoIdentityProvider> cognitoIdentityProviders;
    private final List<String> samlProviderARNs;

    private UpdateIdentityPoolRequest(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
        this.allowUnauthenticatedIdentities = builder.allowUnauthenticatedIdentities;
        this.supportedLoginProviders = builder.supportedLoginProviders;
        this.developerProviderName = builder.developerProviderName;
        this.openIdConnectProviderARNs = builder.openIdConnectProviderARNs;
        this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
        this.samlProviderARNs = builder.samlProviderARNs;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityPoolName() {
        return this.identityPoolName;
    }

    public Boolean allowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> supportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public List<String> openIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public List<CognitoIdentityProvider> cognitoIdentityProviders() {
        return this.cognitoIdentityProviders;
    }

    public List<String> samlProviderARNs() {
        return this.samlProviderARNs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.identityPoolName() == null ? 0 : this.identityPoolName().hashCode());
        hashCode = 31 * hashCode + (this.allowUnauthenticatedIdentities() == null ? 0 : this.allowUnauthenticatedIdentities().hashCode());
        hashCode = 31 * hashCode + (this.supportedLoginProviders() == null ? 0 : this.supportedLoginProviders().hashCode());
        hashCode = 31 * hashCode + (this.developerProviderName() == null ? 0 : this.developerProviderName().hashCode());
        hashCode = 31 * hashCode + (this.openIdConnectProviderARNs() == null ? 0 : this.openIdConnectProviderARNs().hashCode());
        hashCode = 31 * hashCode + (this.cognitoIdentityProviders() == null ? 0 : this.cognitoIdentityProviders().hashCode());
        hashCode = 31 * hashCode + (this.samlProviderARNs() == null ? 0 : this.samlProviderARNs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentityPoolRequest)) {
            return false;
        }
        UpdateIdentityPoolRequest other = (UpdateIdentityPoolRequest)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.identityPoolName() == null ^ this.identityPoolName() == null) {
            return false;
        }
        if (other.identityPoolName() != null && !other.identityPoolName().equals(this.identityPoolName())) {
            return false;
        }
        if (other.allowUnauthenticatedIdentities() == null ^ this.allowUnauthenticatedIdentities() == null) {
            return false;
        }
        if (other.allowUnauthenticatedIdentities() != null && !other.allowUnauthenticatedIdentities().equals(this.allowUnauthenticatedIdentities())) {
            return false;
        }
        if (other.supportedLoginProviders() == null ^ this.supportedLoginProviders() == null) {
            return false;
        }
        if (other.supportedLoginProviders() != null && !other.supportedLoginProviders().equals(this.supportedLoginProviders())) {
            return false;
        }
        if (other.developerProviderName() == null ^ this.developerProviderName() == null) {
            return false;
        }
        if (other.developerProviderName() != null && !other.developerProviderName().equals(this.developerProviderName())) {
            return false;
        }
        if (other.openIdConnectProviderARNs() == null ^ this.openIdConnectProviderARNs() == null) {
            return false;
        }
        if (other.openIdConnectProviderARNs() != null && !other.openIdConnectProviderARNs().equals(this.openIdConnectProviderARNs())) {
            return false;
        }
        if (other.cognitoIdentityProviders() == null ^ this.cognitoIdentityProviders() == null) {
            return false;
        }
        if (other.cognitoIdentityProviders() != null && !other.cognitoIdentityProviders().equals(this.cognitoIdentityProviders())) {
            return false;
        }
        if (other.samlProviderARNs() == null ^ this.samlProviderARNs() == null) {
            return false;
        }
        return other.samlProviderARNs() == null || other.samlProviderARNs().equals(this.samlProviderARNs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.identityPoolName() != null) {
            sb.append("IdentityPoolName: ").append(this.identityPoolName()).append(",");
        }
        if (this.allowUnauthenticatedIdentities() != null) {
            sb.append("AllowUnauthenticatedIdentities: ").append(this.allowUnauthenticatedIdentities()).append(",");
        }
        if (this.supportedLoginProviders() != null) {
            sb.append("SupportedLoginProviders: ").append(this.supportedLoginProviders()).append(",");
        }
        if (this.developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(this.developerProviderName()).append(",");
        }
        if (this.openIdConnectProviderARNs() != null) {
            sb.append("OpenIdConnectProviderARNs: ").append(this.openIdConnectProviderARNs()).append(",");
        }
        if (this.cognitoIdentityProviders() != null) {
            sb.append("CognitoIdentityProviders: ").append(this.cognitoIdentityProviders()).append(",");
        }
        if (this.samlProviderARNs() != null) {
            sb.append("SamlProviderARNs: ").append(this.samlProviderARNs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityPoolName;
        private Boolean allowUnauthenticatedIdentities;
        private Map<String, String> supportedLoginProviders;
        private String developerProviderName;
        private List<String> openIdConnectProviderARNs;
        private List<CognitoIdentityProvider> cognitoIdentityProviders;
        private List<String> samlProviderARNs;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentityPoolRequest model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setIdentityPoolName(model.identityPoolName);
            this.setAllowUnauthenticatedIdentities(model.allowUnauthenticatedIdentities);
            this.setSupportedLoginProviders(model.supportedLoginProviders);
            this.setDeveloperProviderName(model.developerProviderName);
            this.setOpenIdConnectProviderARNs(model.openIdConnectProviderARNs);
            this.setCognitoIdentityProviders(model.cognitoIdentityProviders);
            this.setSamlProviderARNs(model.samlProviderARNs);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return this.identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        public final Boolean getAllowUnauthenticatedIdentities() {
            return this.allowUnauthenticatedIdentities;
        }

        @Override
        public final Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        public final void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        }

        public final Map<String, String> getSupportedLoginProviders() {
            return this.supportedLoginProviders;
        }

        @Override
        public final Builder supportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
            return this;
        }

        public final void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final Collection<String> getOpenIdConnectProviderARNs() {
            return this.openIdConnectProviderARNs;
        }

        @Override
        public final Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
            return this;
        }

        public final void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
        }

        @SafeVarargs
        public final void setOpenIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
        }

        public final Collection<CognitoIdentityProvider> getCognitoIdentityProviders() {
            return this.cognitoIdentityProviders;
        }

        @Override
        public final Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
            return this;
        }

        public final void setCognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
        }

        @SafeVarargs
        public final void setCognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
        }

        public final Collection<String> getSamlProviderARNs() {
            return this.samlProviderARNs;
        }

        @Override
        public final Builder samlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderARNs(String ... samlProviderARNs) {
            this.samlProviderARNs(Arrays.asList(samlProviderARNs));
            return this;
        }

        public final void setSamlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
        }

        @SafeVarargs
        public final void setSamlProviderARNs(String ... samlProviderARNs) {
            this.samlProviderARNs(Arrays.asList(samlProviderARNs));
        }

        public UpdateIdentityPoolRequest build() {
            return new UpdateIdentityPoolRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateIdentityPoolRequest> {
        public Builder identityPoolId(String var1);

        public Builder identityPoolName(String var1);

        public Builder allowUnauthenticatedIdentities(Boolean var1);

        public Builder supportedLoginProviders(Map<String, String> var1);

        public Builder developerProviderName(String var1);

        public Builder openIdConnectProviderARNs(Collection<String> var1);

        public Builder openIdConnectProviderARNs(String ... var1);

        public Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> var1);

        public Builder cognitoIdentityProviders(CognitoIdentityProvider ... var1);

        public Builder samlProviderARNs(Collection<String> var1);

        public Builder samlProviderARNs(String ... var1);
    }
}

