/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MergeDeveloperIdentitiesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
    private final String sourceUserIdentifier;
    private final String destinationUserIdentifier;
    private final String developerProviderName;
    private final String identityPoolId;

    private MergeDeveloperIdentitiesRequest(BuilderImpl builder) {
        this.sourceUserIdentifier = builder.sourceUserIdentifier;
        this.destinationUserIdentifier = builder.destinationUserIdentifier;
        this.developerProviderName = builder.developerProviderName;
        this.identityPoolId = builder.identityPoolId;
    }

    public String sourceUserIdentifier() {
        return this.sourceUserIdentifier;
    }

    public String destinationUserIdentifier() {
        return this.destinationUserIdentifier;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceUserIdentifier() == null ? 0 : this.sourceUserIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.destinationUserIdentifier() == null ? 0 : this.destinationUserIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.developerProviderName() == null ? 0 : this.developerProviderName().hashCode());
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeDeveloperIdentitiesRequest)) {
            return false;
        }
        MergeDeveloperIdentitiesRequest other = (MergeDeveloperIdentitiesRequest)((Object)obj);
        if (other.sourceUserIdentifier() == null ^ this.sourceUserIdentifier() == null) {
            return false;
        }
        if (other.sourceUserIdentifier() != null && !other.sourceUserIdentifier().equals(this.sourceUserIdentifier())) {
            return false;
        }
        if (other.destinationUserIdentifier() == null ^ this.destinationUserIdentifier() == null) {
            return false;
        }
        if (other.destinationUserIdentifier() != null && !other.destinationUserIdentifier().equals(this.destinationUserIdentifier())) {
            return false;
        }
        if (other.developerProviderName() == null ^ this.developerProviderName() == null) {
            return false;
        }
        if (other.developerProviderName() != null && !other.developerProviderName().equals(this.developerProviderName())) {
            return false;
        }
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        return other.identityPoolId() == null || other.identityPoolId().equals(this.identityPoolId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceUserIdentifier() != null) {
            sb.append("SourceUserIdentifier: ").append(this.sourceUserIdentifier()).append(",");
        }
        if (this.destinationUserIdentifier() != null) {
            sb.append("DestinationUserIdentifier: ").append(this.destinationUserIdentifier()).append(",");
        }
        if (this.developerProviderName() != null) {
            sb.append("DeveloperProviderName: ").append(this.developerProviderName()).append(",");
        }
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceUserIdentifier;
        private String destinationUserIdentifier;
        private String developerProviderName;
        private String identityPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeDeveloperIdentitiesRequest model) {
            this.setSourceUserIdentifier(model.sourceUserIdentifier);
            this.setDestinationUserIdentifier(model.destinationUserIdentifier);
            this.setDeveloperProviderName(model.developerProviderName);
            this.setIdentityPoolId(model.identityPoolId);
        }

        public final String getSourceUserIdentifier() {
            return this.sourceUserIdentifier;
        }

        @Override
        public final Builder sourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
            return this;
        }

        public final void setSourceUserIdentifier(String sourceUserIdentifier) {
            this.sourceUserIdentifier = sourceUserIdentifier;
        }

        public final String getDestinationUserIdentifier() {
            return this.destinationUserIdentifier;
        }

        @Override
        public final Builder destinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
            return this;
        }

        public final void setDestinationUserIdentifier(String destinationUserIdentifier) {
            this.destinationUserIdentifier = destinationUserIdentifier;
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public MergeDeveloperIdentitiesRequest build() {
            return new MergeDeveloperIdentitiesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MergeDeveloperIdentitiesRequest> {
        public Builder sourceUserIdentifier(String var1);

        public Builder destinationUserIdentifier(String var1);

        public Builder developerProviderName(String var1);

        public Builder identityPoolId(String var1);
    }
}

