/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMapping;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingMapCopier;
import software.amazon.awssdk.services.cognitoidentity.model.RolesMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetIdentityPoolRolesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
    private final String identityPoolId;
    private final Map<String, String> roles;
    private final Map<String, RoleMapping> roleMappings;

    private GetIdentityPoolRolesResponse(BuilderImpl builder) {
        this.identityPoolId = builder.identityPoolId;
        this.roles = builder.roles;
        this.roleMappings = builder.roleMappings;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public Map<String, String> roles() {
        return this.roles;
    }

    public Map<String, RoleMapping> roleMappings() {
        return this.roleMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityPoolId() == null ? 0 : this.identityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.roles() == null ? 0 : this.roles().hashCode());
        hashCode = 31 * hashCode + (this.roleMappings() == null ? 0 : this.roleMappings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoolRolesResponse)) {
            return false;
        }
        GetIdentityPoolRolesResponse other = (GetIdentityPoolRolesResponse)((Object)obj);
        if (other.identityPoolId() == null ^ this.identityPoolId() == null) {
            return false;
        }
        if (other.identityPoolId() != null && !other.identityPoolId().equals(this.identityPoolId())) {
            return false;
        }
        if (other.roles() == null ^ this.roles() == null) {
            return false;
        }
        if (other.roles() != null && !other.roles().equals(this.roles())) {
            return false;
        }
        if (other.roleMappings() == null ^ this.roleMappings() == null) {
            return false;
        }
        return other.roleMappings() == null || other.roleMappings().equals(this.roleMappings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.identityPoolId()).append(",");
        }
        if (this.roles() != null) {
            sb.append("Roles: ").append(this.roles()).append(",");
        }
        if (this.roleMappings() != null) {
            sb.append("RoleMappings: ").append(this.roleMappings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityPoolId;
        private Map<String, String> roles;
        private Map<String, RoleMapping> roleMappings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoolRolesResponse model) {
            this.setIdentityPoolId(model.identityPoolId);
            this.setRoles(model.roles);
            this.setRoleMappings(model.roleMappings);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Map<String, String> getRoles() {
            return this.roles;
        }

        @Override
        public final Builder roles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
            return this;
        }

        public final void setRoles(Map<String, String> roles) {
            this.roles = RolesMapCopier.copy(roles);
        }

        public final Map<String, RoleMapping> getRoleMappings() {
            return this.roleMappings;
        }

        @Override
        public final Builder roleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
            return this;
        }

        public final void setRoleMappings(Map<String, RoleMapping> roleMappings) {
            this.roleMappings = RoleMappingMapCopier.copy(roleMappings);
        }

        public GetIdentityPoolRolesResponse build() {
            return new GetIdentityPoolRolesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetIdentityPoolRolesResponse> {
        public Builder identityPoolId(String var1);

        public Builder roles(Map<String, String> var1);

        public Builder roleMappings(Map<String, RoleMapping> var1);
    }
}

