/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNotificationRuleRequest extends CodestarNotificationsRequest implements
        ToCopyableBuilder<UpdateNotificationRuleRequest.Builder, UpdateNotificationRuleRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateNotificationRuleRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateNotificationRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateNotificationRuleRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> EVENT_TYPE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventTypeIds")
            .getter(getter(UpdateNotificationRuleRequest::eventTypeIds))
            .setter(setter(Builder::eventTypeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTypeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(UpdateNotificationRuleRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(UpdateNotificationRuleRequest::detailTypeAsString))
            .setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, EVENT_TYPE_IDS_FIELD, TARGETS_FIELD, DETAIL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String name;

    private final String status;

    private final List<String> eventTypeIds;

    private final List<Target> targets;

    private final String detailType;

    private UpdateNotificationRuleRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.eventTypeIds = builder.eventTypeIds;
        this.targets = builder.targets;
        this.detailType = builder.detailType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notification rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notification rule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the notification rule.
     * </p>
     * 
     * @return The name of the notification rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not
     * sending notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled
     *         (not sending notifications).
     * @see NotificationRuleStatus
     */
    public final NotificationRuleStatus status() {
        return NotificationRuleStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not
     * sending notifications).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NotificationRuleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled
     *         (not sending notifications).
     * @see NotificationRuleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTypeIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTypeIds() {
        return eventTypeIds != null && !(eventTypeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event types associated with this notification rule. For a complete list of event types and IDs, see <a
     * href
     * ="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api">Notification
     * concepts</a> in the <i>Developer Tools Console User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTypeIds} method.
     * </p>
     * 
     * @return A list of event types associated with this notification rule. For a complete list of event types and IDs,
     *         see <a
     *         href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
     *         >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
     */
    public final List<String> eventTypeIds() {
        return eventTypeIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The address and type of the targets to receive notifications from this notification rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The address and type of the targets to receive notifications from this notification rule.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The level of detail to include in the notifications for this resource. BASIC will include only the contents of
     * the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail to include in the notifications for this resource. BASIC will include only the
     *         contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
     *         information provided by CodeStar Notifications and/or the service for the resource for which the
     *         notification is created.
     * @see DetailType
     */
    public final DetailType detailType() {
        return DetailType.fromValue(detailType);
    }

    /**
     * <p>
     * The level of detail to include in the notifications for this resource. BASIC will include only the contents of
     * the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided by
     * CodeStar Notifications and/or the service for the resource for which the notification is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #detailType} will
     * return {@link DetailType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #detailTypeAsString}.
     * </p>
     * 
     * @return The level of detail to include in the notifications for this resource. BASIC will include only the
     *         contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
     *         information provided by CodeStar Notifications and/or the service for the resource for which the
     *         notification is created.
     * @see DetailType
     */
    public final String detailTypeAsString() {
        return detailType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTypeIds() ? eventTypeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(detailTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotificationRuleRequest)) {
            return false;
        }
        UpdateNotificationRuleRequest other = (UpdateNotificationRuleRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasEventTypeIds() == other.hasEventTypeIds()
                && Objects.equals(eventTypeIds(), other.eventTypeIds()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(detailTypeAsString(), other.detailTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNotificationRuleRequest").add("Arn", arn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("EventTypeIds", hasEventTypeIds() ? eventTypeIds() : null).add("Targets", hasTargets() ? targets() : null)
                .add("DetailType", detailTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "EventTypeIds":
            return Optional.ofNullable(clazz.cast(eventTypeIds()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EventTypeIds", EVENT_TYPE_IDS_FIELD);
        map.put("Targets", TARGETS_FIELD);
        map.put("DetailType", DETAIL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotificationRuleRequest, T> g) {
        return obj -> g.apply((UpdateNotificationRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodestarNotificationsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateNotificationRuleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notification rule.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the notification rule.
         * </p>
         * 
         * @param name
         *        The name of the notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not
         * sending notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses include enabled (sending notifications) or
         *        disabled (not sending notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the notification rule. Valid statuses include enabled (sending notifications) or disabled (not
         * sending notifications).
         * </p>
         * 
         * @param status
         *        The status of the notification rule. Valid statuses include enabled (sending notifications) or
         *        disabled (not sending notifications).
         * @see NotificationRuleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationRuleStatus
         */
        Builder status(NotificationRuleStatus status);

        /**
         * <p>
         * A list of event types associated with this notification rule. For a complete list of event types and IDs, see
         * <a href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api">
         * Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * </p>
         * 
         * @param eventTypeIds
         *        A list of event types associated with this notification rule. For a complete list of event types and
         *        IDs, see <a href=
         *        "https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
         *        >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeIds(Collection<String> eventTypeIds);

        /**
         * <p>
         * A list of event types associated with this notification rule. For a complete list of event types and IDs, see
         * <a href="https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api">
         * Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * </p>
         * 
         * @param eventTypeIds
         *        A list of event types associated with this notification rule. For a complete list of event types and
         *        IDs, see <a href=
         *        "https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api"
         *        >Notification concepts</a> in the <i>Developer Tools Console User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeIds(String... eventTypeIds);

        /**
         * <p>
         * The address and type of the targets to receive notifications from this notification rule.
         * </p>
         * 
         * @param targets
         *        The address and type of the targets to receive notifications from this notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The address and type of the targets to receive notifications from this notification rule.
         * </p>
         * 
         * @param targets
         *        The address and type of the targets to receive notifications from this notification rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The address and type of the targets to receive notifications from this notification rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codestarnotifications.model.Target.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codestarnotifications.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codestarnotifications.model.Target.Builder#build()} is called
         * immediately and its result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codestarnotifications.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(java.util.Collection<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The level of detail to include in the notifications for this resource. BASIC will include only the contents
         * of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided
         * by CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail to include in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
         *        information provided by CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * The level of detail to include in the notifications for this resource. BASIC will include only the contents
         * of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental information provided
         * by CodeStar Notifications and/or the service for the resource for which the notification is created.
         * </p>
         * 
         * @param detailType
         *        The level of detail to include in the notifications for this resource. BASIC will include only the
         *        contents of the event as it would appear in Amazon CloudWatch. FULL will include any supplemental
         *        information provided by CodeStar Notifications and/or the service for the resource for which the
         *        notification is created.
         * @see DetailType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DetailType
         */
        Builder detailType(DetailType detailType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodestarNotificationsRequest.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String status;

        private List<String> eventTypeIds = DefaultSdkAutoConstructList.getInstance();

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String detailType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotificationRuleRequest model) {
            super(model);
            arn(model.arn);
            name(model.name);
            status(model.status);
            eventTypeIds(model.eventTypeIds);
            targets(model.targets);
            detailType(model.detailType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotificationRuleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getEventTypeIds() {
            if (eventTypeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return eventTypeIds;
        }

        public final void setEventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
        }

        @Override
        public final Builder eventTypeIds(Collection<String> eventTypeIds) {
            this.eventTypeIds = EventTypeIdsCopier.copy(eventTypeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeIds(String... eventTypeIds) {
            eventTypeIds(Arrays.asList(eventTypeIds));
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDetailType() {
            return detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        @Override
        public final Builder detailType(DetailType detailType) {
            this.detailType(detailType == null ? null : detailType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotificationRuleRequest build() {
            return new UpdateNotificationRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
