/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.CodestarNotificationsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarnotifications.DefaultCodestarNotificationsClientBuilder;
import software.amazon.awssdk.services.codestarnotifications.model.AccessDeniedException;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsException;
import software.amazon.awssdk.services.codestarnotifications.model.ConcurrentModificationException;
import software.amazon.awssdk.services.codestarnotifications.model.ConfigurationException;
import software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.CreateNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DeleteTargetResponse;
import software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.DescribeNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.InvalidNextTokenException;
import software.amazon.awssdk.services.codestarnotifications.model.LimitExceededException;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListEventTypesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListNotificationRulesResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ListTargetsRequest;
import software.amazon.awssdk.services.codestarnotifications.model.ListTargetsResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.codestarnotifications.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codestarnotifications.model.SubscribeRequest;
import software.amazon.awssdk.services.codestarnotifications.model.SubscribeResponse;
import software.amazon.awssdk.services.codestarnotifications.model.TagResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.TagResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UnsubscribeResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UntagResourceRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UntagResourceResponse;
import software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleRequest;
import software.amazon.awssdk.services.codestarnotifications.model.UpdateNotificationRuleResponse;
import software.amazon.awssdk.services.codestarnotifications.model.ValidationException;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListEventTypesIterable;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListNotificationRulesIterable;
import software.amazon.awssdk.services.codestarnotifications.paginators.ListTargetsIterable;

@SdkPublicApi
@ThreadSafe
public interface CodestarNotificationsClient
extends AwsClient {
    public static final String SERVICE_NAME = "codestar-notifications";
    public static final String SERVICE_METADATA_ID = "codestar-notifications";

    default public CreateNotificationRuleResponse createNotificationRule(CreateNotificationRuleRequest createNotificationRuleRequest) throws ResourceAlreadyExistsException, ValidationException, LimitExceededException, ConfigurationException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public CreateNotificationRuleResponse createNotificationRule(Consumer<CreateNotificationRuleRequest.Builder> createNotificationRuleRequest) throws ResourceAlreadyExistsException, ValidationException, LimitExceededException, ConfigurationException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.createNotificationRule((CreateNotificationRuleRequest)((Object)((CreateNotificationRuleRequest.Builder)CreateNotificationRuleRequest.builder().applyMutation(createNotificationRuleRequest)).build()));
    }

    default public DeleteNotificationRuleResponse deleteNotificationRule(DeleteNotificationRuleRequest deleteNotificationRuleRequest) throws ValidationException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteNotificationRuleResponse deleteNotificationRule(Consumer<DeleteNotificationRuleRequest.Builder> deleteNotificationRuleRequest) throws ValidationException, LimitExceededException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.deleteNotificationRule((DeleteNotificationRuleRequest)((Object)((DeleteNotificationRuleRequest.Builder)DeleteNotificationRuleRequest.builder().applyMutation(deleteNotificationRuleRequest)).build()));
    }

    default public DeleteTargetResponse deleteTarget(DeleteTargetRequest deleteTargetRequest) throws ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public DeleteTargetResponse deleteTarget(Consumer<DeleteTargetRequest.Builder> deleteTargetRequest) throws ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.deleteTarget((DeleteTargetRequest)((Object)((DeleteTargetRequest.Builder)DeleteTargetRequest.builder().applyMutation(deleteTargetRequest)).build()));
    }

    default public DescribeNotificationRuleResponse describeNotificationRule(DescribeNotificationRuleRequest describeNotificationRuleRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public DescribeNotificationRuleResponse describeNotificationRule(Consumer<DescribeNotificationRuleRequest.Builder> describeNotificationRuleRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.describeNotificationRule((DescribeNotificationRuleRequest)((Object)((DescribeNotificationRuleRequest.Builder)DescribeNotificationRuleRequest.builder().applyMutation(describeNotificationRuleRequest)).build()));
    }

    default public ListEventTypesResponse listEventTypes(ListEventTypesRequest listEventTypesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListEventTypesResponse listEventTypes(Consumer<ListEventTypesRequest.Builder> listEventTypesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listEventTypes((ListEventTypesRequest)((Object)((ListEventTypesRequest.Builder)ListEventTypesRequest.builder().applyMutation(listEventTypesRequest)).build()));
    }

    default public ListEventTypesIterable listEventTypesPaginator(ListEventTypesRequest listEventTypesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListEventTypesIterable listEventTypesPaginator(Consumer<ListEventTypesRequest.Builder> listEventTypesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listEventTypesPaginator((ListEventTypesRequest)((Object)((ListEventTypesRequest.Builder)ListEventTypesRequest.builder().applyMutation(listEventTypesRequest)).build()));
    }

    default public ListNotificationRulesResponse listNotificationRules(ListNotificationRulesRequest listNotificationRulesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListNotificationRulesResponse listNotificationRules(Consumer<ListNotificationRulesRequest.Builder> listNotificationRulesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listNotificationRules((ListNotificationRulesRequest)((Object)((ListNotificationRulesRequest.Builder)ListNotificationRulesRequest.builder().applyMutation(listNotificationRulesRequest)).build()));
    }

    default public ListNotificationRulesIterable listNotificationRulesPaginator(ListNotificationRulesRequest listNotificationRulesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListNotificationRulesIterable listNotificationRulesPaginator(Consumer<ListNotificationRulesRequest.Builder> listNotificationRulesRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listNotificationRulesPaginator((ListNotificationRulesRequest)((Object)((ListNotificationRulesRequest.Builder)ListNotificationRulesRequest.builder().applyMutation(listNotificationRulesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public ListTargetsResponse listTargets(ListTargetsRequest listTargetsRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListTargetsResponse listTargets(Consumer<ListTargetsRequest.Builder> listTargetsRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listTargets((ListTargetsRequest)((Object)((ListTargetsRequest.Builder)ListTargetsRequest.builder().applyMutation(listTargetsRequest)).build()));
    }

    default public ListTargetsIterable listTargetsPaginator(ListTargetsRequest listTargetsRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public ListTargetsIterable listTargetsPaginator(Consumer<ListTargetsRequest.Builder> listTargetsRequest) throws InvalidNextTokenException, ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.listTargetsPaginator((ListTargetsRequest)((Object)((ListTargetsRequest.Builder)ListTargetsRequest.builder().applyMutation(listTargetsRequest)).build()));
    }

    default public SubscribeResponse subscribe(SubscribeRequest subscribeRequest) throws ValidationException, ResourceNotFoundException, ConfigurationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public SubscribeResponse subscribe(Consumer<SubscribeRequest.Builder> subscribeRequest) throws ValidationException, ResourceNotFoundException, ConfigurationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.subscribe((SubscribeRequest)((Object)((SubscribeRequest.Builder)SubscribeRequest.builder().applyMutation(subscribeRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, LimitExceededException, ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, LimitExceededException, ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UnsubscribeResponse unsubscribe(UnsubscribeRequest unsubscribeRequest) throws ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public UnsubscribeResponse unsubscribe(Consumer<UnsubscribeRequest.Builder> unsubscribeRequest) throws ValidationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.unsubscribe((UnsubscribeRequest)((Object)((UnsubscribeRequest.Builder)UnsubscribeRequest.builder().applyMutation(unsubscribeRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, LimitExceededException, ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, LimitExceededException, ValidationException, ConcurrentModificationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateNotificationRuleResponse updateNotificationRule(UpdateNotificationRuleRequest updateNotificationRuleRequest) throws ValidationException, ResourceNotFoundException, ConfigurationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        throw new UnsupportedOperationException();
    }

    default public UpdateNotificationRuleResponse updateNotificationRule(Consumer<UpdateNotificationRuleRequest.Builder> updateNotificationRuleRequest) throws ValidationException, ResourceNotFoundException, ConfigurationException, AwsServiceException, SdkClientException, CodestarNotificationsException {
        return this.updateNotificationRule((UpdateNotificationRuleRequest)((Object)((UpdateNotificationRuleRequest.Builder)UpdateNotificationRuleRequest.builder().applyMutation(updateNotificationRuleRequest)).build()));
    }

    public static CodestarNotificationsClient create() {
        return (CodestarNotificationsClient)CodestarNotificationsClient.builder().build();
    }

    public static CodestarNotificationsClientBuilder builder() {
        return new DefaultCodestarNotificationsClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"codestar-notifications");
    }

    public CodestarNotificationsServiceClientConfiguration serviceClientConfiguration();
}

