/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DetailType {
    BASIC("BASIC"),
    FULL("FULL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DetailType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetailType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DetailType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetailType> knownValues() {
        return Stream.of(DetailType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

