/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTargetsRequest extends CodestarNotificationsRequest implements
        ToCopyableBuilder<ListTargetsRequest.Builder, ListTargetsRequest> {
    private static final SdkField<List<ListTargetsFilter>> FILTERS_FIELD = SdkField
            .<List<ListTargetsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListTargetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListTargetsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListTargetsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTargetsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTargetsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<ListTargetsFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private ListTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters to use to return information by service or resource type. Valid filters include target type, target
     * address, and target status.
     * </p>
     * <note>
     * <p>
     * A filter with the same name can appear more than once when used with OR statements. Filters with different names
     * should be applied with AND statements.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filters to use to return information by service or resource type. Valid filters include target type,
     *         target address, and target status.</p> <note>
     *         <p>
     *         A filter with the same name can appear more than once when used with OR statements. Filters with
     *         different names should be applied with AND statements.
     *         </p>
     */
    public final List<ListTargetsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * An enumeration token that, when provided in a request, returns the next batch of the results.
     * </p>
     * 
     * @return An enumeration token that, when provided in a request, returns the next batch of the results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A non-negative integer used to limit the number of returned results. The maximum number of results that can be
     * returned is 100.
     * </p>
     * 
     * @return A non-negative integer used to limit the number of returned results. The maximum number of results that
     *         can be returned is 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTargetsRequest)) {
            return false;
        }
        ListTargetsRequest other = (ListTargetsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTargetsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTargetsRequest, T> g) {
        return obj -> g.apply((ListTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodestarNotificationsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTargetsRequest> {
        /**
         * <p>
         * The filters to use to return information by service or resource type. Valid filters include target type,
         * target address, and target status.
         * </p>
         * <note>
         * <p>
         * A filter with the same name can appear more than once when used with OR statements. Filters with different
         * names should be applied with AND statements.
         * </p>
         * </note>
         * 
         * @param filters
         *        The filters to use to return information by service or resource type. Valid filters include target
         *        type, target address, and target status.</p> <note>
         *        <p>
         *        A filter with the same name can appear more than once when used with OR statements. Filters with
         *        different names should be applied with AND statements.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ListTargetsFilter> filters);

        /**
         * <p>
         * The filters to use to return information by service or resource type. Valid filters include target type,
         * target address, and target status.
         * </p>
         * <note>
         * <p>
         * A filter with the same name can appear more than once when used with OR statements. Filters with different
         * names should be applied with AND statements.
         * </p>
         * </note>
         * 
         * @param filters
         *        The filters to use to return information by service or resource type. Valid filters include target
         *        type, target address, and target status.</p> <note>
         *        <p>
         *        A filter with the same name can appear more than once when used with OR statements. Filters with
         *        different names should be applied with AND statements.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ListTargetsFilter... filters);

        /**
         * <p>
         * The filters to use to return information by service or resource type. Valid filters include target type,
         * target address, and target status.
         * </p>
         * <note>
         * <p>
         * A filter with the same name can appear more than once when used with OR statements. Filters with different
         * names should be applied with AND statements.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<ListTargetsFilter>.Builder}
         * avoiding the need to create one manually via {@link List<ListTargetsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListTargetsFilter>.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<ListTargetsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ListTargetsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ListTargetsFilter>)
         */
        Builder filters(Consumer<ListTargetsFilter.Builder>... filters);

        /**
         * <p>
         * An enumeration token that, when provided in a request, returns the next batch of the results.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that, when provided in a request, returns the next batch of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A non-negative integer used to limit the number of returned results. The maximum number of results that can
         * be returned is 100.
         * </p>
         * 
         * @param maxResults
         *        A non-negative integer used to limit the number of returned results. The maximum number of results
         *        that can be returned is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodestarNotificationsRequest.BuilderImpl implements Builder {
        private List<ListTargetsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTargetsRequest model) {
            super(model);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<ListTargetsFilter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(ListTargetsFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ListTargetsFilter> filters) {
            this.filters = ListTargetsFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ListTargetsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ListTargetsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ListTargetsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ListTargetsFilter.BuilderImpl> filters) {
            this.filters = ListTargetsFiltersCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTargetsRequest build() {
            return new ListTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
