/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codestarnotifications.model.CodestarNotificationsResponse;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleBatchCopier;
import software.amazon.awssdk.services.codestarnotifications.model.NotificationRuleSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotificationRulesResponse
extends CodestarNotificationsResponse
implements ToCopyableBuilder<Builder, ListNotificationRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListNotificationRulesResponse.getter(ListNotificationRulesResponse::nextToken)).setter(ListNotificationRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<NotificationRuleSummary>> NOTIFICATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListNotificationRulesResponse.getter(ListNotificationRulesResponse::notificationRules)).setter(ListNotificationRulesResponse.setter(Builder::notificationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationRuleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NOTIFICATION_RULES_FIELD));
    private final String nextToken;
    private final List<NotificationRuleSummary> notificationRules;

    private ListNotificationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notificationRules = builder.notificationRules;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<NotificationRuleSummary> notificationRules() {
        return this.notificationRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotificationRulesResponse)) {
            return false;
        }
        ListNotificationRulesResponse other = (ListNotificationRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.notificationRules(), other.notificationRules());
    }

    public String toString() {
        return ToString.builder((String)"ListNotificationRulesResponse").add("NextToken", (Object)this.nextToken()).add("NotificationRules", this.notificationRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NotificationRules": {
                return Optional.ofNullable(clazz.cast(this.notificationRules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotificationRulesResponse, T> g) {
        return obj -> g.apply((ListNotificationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodestarNotificationsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotificationRuleSummary> notificationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotificationRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notificationRules(model.notificationRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotificationRuleSummary.Builder> getNotificationRules() {
            return this.notificationRules != null ? (Collection)this.notificationRules.stream().map(NotificationRuleSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationRules(Collection<NotificationRuleSummary> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copy(notificationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(NotificationRuleSummary ... notificationRules) {
            this.notificationRules(Arrays.asList(notificationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationRules(Consumer<NotificationRuleSummary.Builder> ... notificationRules) {
            this.notificationRules(Stream.of(notificationRules).map(c -> (NotificationRuleSummary)((NotificationRuleSummary.Builder)NotificationRuleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationRules(Collection<NotificationRuleSummary.BuilderImpl> notificationRules) {
            this.notificationRules = NotificationRuleBatchCopier.copyFromBuilder(notificationRules);
        }

        @Override
        public ListNotificationRulesResponse build() {
            return new ListNotificationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodestarNotificationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotificationRulesResponse> {
        public Builder nextToken(String var1);

        public Builder notificationRules(Collection<NotificationRuleSummary> var1);

        public Builder notificationRules(NotificationRuleSummary ... var1);

        public Builder notificationRules(Consumer<NotificationRuleSummary.Builder> ... var1);
    }
}

