/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsAsyncClient;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsAsyncClientBuilder;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsAsyncClient;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsBaseClientBuilder;
import software.amazon.awssdk.services.codestarconnections.endpoints.CodeStarConnectionsEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarConnectionsAsyncClientBuilder
extends DefaultCodeStarConnectionsBaseClientBuilder<CodeStarConnectionsAsyncClientBuilder, CodeStarConnectionsAsyncClient>
implements CodeStarConnectionsAsyncClientBuilder {
    DefaultCodeStarConnectionsAsyncClientBuilder() {
    }

    @Override
    public DefaultCodeStarConnectionsAsyncClientBuilder endpointProvider(CodeStarConnectionsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarConnectionsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCodeStarConnectionsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CodeStarConnectionsServiceClientConfiguration serviceClientConfiguration = CodeStarConnectionsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCodeStarConnectionsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

