/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.ConnectionStatus;
import software.amazon.awssdk.services.codestarconnections.model.ProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connection> {
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::connectionName)).setter(Connection.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::connectionArn)).setter(Connection.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::providerTypeAsString)).setter(Connection.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::ownerAccountId)).setter(Connection.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::connectionStatusAsString)).setter(Connection.setter(Builder::connectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_NAME_FIELD, CONNECTION_ARN_FIELD, PROVIDER_TYPE_FIELD, OWNER_ACCOUNT_ID_FIELD, CONNECTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectionName;
    private final String connectionArn;
    private final String providerType;
    private final String ownerAccountId;
    private final String connectionStatus;

    private Connection(BuilderImpl builder) {
        this.connectionName = builder.connectionName;
        this.connectionArn = builder.connectionArn;
        this.providerType = builder.providerType;
        this.ownerAccountId = builder.ownerAccountId;
        this.connectionStatus = builder.connectionStatus;
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String connectionArn() {
        return this.connectionArn;
    }

    public ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public String providerTypeAsString() {
        return this.providerType;
    }

    public String ownerAccountId() {
        return this.ownerAccountId;
    }

    public ConnectionStatus connectionStatus() {
        return ConnectionStatus.fromValue(this.connectionStatus);
    }

    public String connectionStatusAsString() {
        return this.connectionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId()) && Objects.equals(this.connectionStatusAsString(), other.connectionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"Connection").add("ConnectionName", (Object)this.connectionName()).add("ConnectionArn", (Object)this.connectionArn()).add("ProviderType", (Object)this.providerTypeAsString()).add("OwnerAccountId", (Object)this.ownerAccountId()).add("ConnectionStatus", (Object)this.connectionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionName;
        private String connectionArn;
        private String providerType;
        private String ownerAccountId;
        private String connectionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            this.connectionName(model.connectionName);
            this.connectionArn(model.connectionArn);
            this.providerType(model.providerType);
            this.ownerAccountId(model.ownerAccountId);
            this.connectionStatus(model.connectionStatus);
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        public final String getProviderTypeAsString() {
            return this.providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        public final String getConnectionStatusAsString() {
            return this.connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(ConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        public Connection build() {
            return new Connection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connection> {
        public Builder connectionName(String var1);

        public Builder connectionArn(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder ownerAccountId(String var1);

        public Builder connectionStatus(String var1);

        public Builder connectionStatus(ConnectionStatus var1);
    }
}

