/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.internal.UserAgentUtils;
import software.amazon.awssdk.services.codepipeline.model.DeployActionExecutionTarget;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListDeployActionExecutionTargetsResponse;

public class ListDeployActionExecutionTargetsPublisher
implements SdkPublisher<ListDeployActionExecutionTargetsResponse> {
    private final CodePipelineAsyncClient client;
    private final ListDeployActionExecutionTargetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeployActionExecutionTargetsPublisher(CodePipelineAsyncClient client, ListDeployActionExecutionTargetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeployActionExecutionTargetsPublisher(CodePipelineAsyncClient client, ListDeployActionExecutionTargetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeployActionExecutionTargetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeployActionExecutionTargetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeployActionExecutionTarget> targets() {
        Function<ListDeployActionExecutionTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeployActionExecutionTargetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeployActionExecutionTargetsResponseFetcher
    implements AsyncPageFetcher<ListDeployActionExecutionTargetsResponse> {
        private ListDeployActionExecutionTargetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeployActionExecutionTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeployActionExecutionTargetsResponse> nextPage(ListDeployActionExecutionTargetsResponse previousPage) {
            if (previousPage == null) {
                return ListDeployActionExecutionTargetsPublisher.this.client.listDeployActionExecutionTargets(ListDeployActionExecutionTargetsPublisher.this.firstRequest);
            }
            return ListDeployActionExecutionTargetsPublisher.this.client.listDeployActionExecutionTargets((ListDeployActionExecutionTargetsRequest)((Object)ListDeployActionExecutionTargetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

