/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.services.codepipeline.model.CurrentRevision;
import software.amazon.awssdk.services.codepipeline.model.ExecutionDetails;
import software.amazon.awssdk.services.codepipeline.model.OutputVariablesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutJobSuccessResultRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, PutJobSuccessResultRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(PutJobSuccessResultRequest.getter(PutJobSuccessResultRequest::jobId)).setter(PutJobSuccessResultRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<CurrentRevision> CURRENT_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentRevision").getter(PutJobSuccessResultRequest.getter(PutJobSuccessResultRequest::currentRevision)).setter(PutJobSuccessResultRequest.setter(Builder::currentRevision)).constructor(CurrentRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()}).build();
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("continuationToken").getter(PutJobSuccessResultRequest.getter(PutJobSuccessResultRequest::continuationToken)).setter(PutJobSuccessResultRequest.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()}).build();
    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionDetails").getter(PutJobSuccessResultRequest.getter(PutJobSuccessResultRequest::executionDetails)).setter(PutJobSuccessResultRequest.setter(Builder::executionDetails)).constructor(ExecutionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build()}).build();
    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("outputVariables").getter(PutJobSuccessResultRequest.getter(PutJobSuccessResultRequest::outputVariables)).setter(PutJobSuccessResultRequest.setter(Builder::outputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, CURRENT_REVISION_FIELD, CONTINUATION_TOKEN_FIELD, EXECUTION_DETAILS_FIELD, OUTPUT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutJobSuccessResultRequest.memberNameToFieldInitializer();
    private final String jobId;
    private final CurrentRevision currentRevision;
    private final String continuationToken;
    private final ExecutionDetails executionDetails;
    private final Map<String, String> outputVariables;

    private PutJobSuccessResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
        this.outputVariables = builder.outputVariables;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final CurrentRevision currentRevision() {
        return this.currentRevision;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final ExecutionDetails executionDetails() {
        return this.executionDetails;
    }

    public final boolean hasOutputVariables() {
        return this.outputVariables != null && !(this.outputVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> outputVariables() {
        return this.outputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputVariables() ? this.outputVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutJobSuccessResultRequest)) {
            return false;
        }
        PutJobSuccessResultRequest other = (PutJobSuccessResultRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.currentRevision(), other.currentRevision()) && Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.executionDetails(), other.executionDetails()) && this.hasOutputVariables() == other.hasOutputVariables() && Objects.equals(this.outputVariables(), other.outputVariables());
    }

    public final String toString() {
        return ToString.builder((String)"PutJobSuccessResultRequest").add("JobId", (Object)this.jobId()).add("CurrentRevision", (Object)this.currentRevision()).add("ContinuationToken", (Object)this.continuationToken()).add("ExecutionDetails", (Object)this.executionDetails()).add("OutputVariables", this.hasOutputVariables() ? this.outputVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "currentRevision": {
                return Optional.ofNullable(clazz.cast(this.currentRevision()));
            }
            case "continuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "executionDetails": {
                return Optional.ofNullable(clazz.cast(this.executionDetails()));
            }
            case "outputVariables": {
                return Optional.ofNullable(clazz.cast(this.outputVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("currentRevision", CURRENT_REVISION_FIELD);
        map.put("continuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("outputVariables", OUTPUT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutJobSuccessResultRequest, T> g) {
        return obj -> g.apply((PutJobSuccessResultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private CurrentRevision currentRevision;
        private String continuationToken;
        private ExecutionDetails executionDetails;
        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutJobSuccessResultRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.currentRevision(model.currentRevision);
            this.continuationToken(model.continuationToken);
            this.executionDetails(model.executionDetails);
            this.outputVariables(model.outputVariables);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return this.currentRevision != null ? this.currentRevision.toBuilder() : null;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return this.executionDetails != null ? this.executionDetails.toBuilder() : null;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final Map<String, String> getOutputVariables() {
            if (this.outputVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputVariables;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutJobSuccessResultRequest build() {
            return new PutJobSuccessResultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutJobSuccessResultRequest> {
        public Builder jobId(String var1);

        public Builder currentRevision(CurrentRevision var1);

        default public Builder currentRevision(Consumer<CurrentRevision.Builder> currentRevision) {
            return this.currentRevision((CurrentRevision)((CurrentRevision.Builder)CurrentRevision.builder().applyMutation(currentRevision)).build());
        }

        public Builder continuationToken(String var1);

        public Builder executionDetails(ExecutionDetails var1);

        default public Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return this.executionDetails((ExecutionDetails)((ExecutionDetails.Builder)ExecutionDetails.builder().applyMutation(executionDetails)).build());
        }

        public Builder outputVariables(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

