/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionState;
import software.amazon.awssdk.services.codepipeline.model.ActionStateListCopier;
import software.amazon.awssdk.services.codepipeline.model.RetryStageMetadata;
import software.amazon.awssdk.services.codepipeline.model.StageConditionState;
import software.amazon.awssdk.services.codepipeline.model.StageExecution;
import software.amazon.awssdk.services.codepipeline.model.StageExecutionListCopier;
import software.amazon.awssdk.services.codepipeline.model.TransitionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StageState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StageState> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageName").getter(StageState.getter(StageState::stageName)).setter(StageState.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<StageExecution> INBOUND_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inboundExecution").getter(StageState.getter(StageState::inboundExecution)).setter(StageState.setter(Builder::inboundExecution)).constructor(StageExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecution").build()}).build();
    private static final SdkField<List<StageExecution>> INBOUND_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inboundExecutions").getter(StageState.getter(StageState::inboundExecutions)).setter(StageState.setter(Builder::inboundExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StageExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TransitionState> INBOUND_TRANSITION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inboundTransitionState").getter(StageState.getter(StageState::inboundTransitionState)).setter(StageState.setter(Builder::inboundTransitionState)).constructor(TransitionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundTransitionState").build()}).build();
    private static final SdkField<List<ActionState>> ACTION_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionStates").getter(StageState.getter(StageState::actionStates)).setter(StageState.setter(Builder::actionStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StageExecution> LATEST_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestExecution").getter(StageState.getter(StageState::latestExecution)).setter(StageState.setter(Builder::latestExecution)).constructor(StageExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()}).build();
    private static final SdkField<StageConditionState> BEFORE_ENTRY_CONDITION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("beforeEntryConditionState").getter(StageState.getter(StageState::beforeEntryConditionState)).setter(StageState.setter(Builder::beforeEntryConditionState)).constructor(StageConditionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeEntryConditionState").build()}).build();
    private static final SdkField<StageConditionState> ON_SUCCESS_CONDITION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onSuccessConditionState").getter(StageState.getter(StageState::onSuccessConditionState)).setter(StageState.setter(Builder::onSuccessConditionState)).constructor(StageConditionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onSuccessConditionState").build()}).build();
    private static final SdkField<StageConditionState> ON_FAILURE_CONDITION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onFailureConditionState").getter(StageState.getter(StageState::onFailureConditionState)).setter(StageState.setter(Builder::onFailureConditionState)).constructor(StageConditionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailureConditionState").build()}).build();
    private static final SdkField<RetryStageMetadata> RETRY_STAGE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryStageMetadata").getter(StageState.getter(StageState::retryStageMetadata)).setter(StageState.setter(Builder::retryStageMetadata)).constructor(RetryStageMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStageMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD, INBOUND_EXECUTION_FIELD, INBOUND_EXECUTIONS_FIELD, INBOUND_TRANSITION_STATE_FIELD, ACTION_STATES_FIELD, LATEST_EXECUTION_FIELD, BEFORE_ENTRY_CONDITION_STATE_FIELD, ON_SUCCESS_CONDITION_STATE_FIELD, ON_FAILURE_CONDITION_STATE_FIELD, RETRY_STAGE_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StageState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stageName;
    private final StageExecution inboundExecution;
    private final List<StageExecution> inboundExecutions;
    private final TransitionState inboundTransitionState;
    private final List<ActionState> actionStates;
    private final StageExecution latestExecution;
    private final StageConditionState beforeEntryConditionState;
    private final StageConditionState onSuccessConditionState;
    private final StageConditionState onFailureConditionState;
    private final RetryStageMetadata retryStageMetadata;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundExecution = builder.inboundExecution;
        this.inboundExecutions = builder.inboundExecutions;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
        this.beforeEntryConditionState = builder.beforeEntryConditionState;
        this.onSuccessConditionState = builder.onSuccessConditionState;
        this.onFailureConditionState = builder.onFailureConditionState;
        this.retryStageMetadata = builder.retryStageMetadata;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final StageExecution inboundExecution() {
        return this.inboundExecution;
    }

    public final boolean hasInboundExecutions() {
        return this.inboundExecutions != null && !(this.inboundExecutions instanceof SdkAutoConstructList);
    }

    public final List<StageExecution> inboundExecutions() {
        return this.inboundExecutions;
    }

    public final TransitionState inboundTransitionState() {
        return this.inboundTransitionState;
    }

    public final boolean hasActionStates() {
        return this.actionStates != null && !(this.actionStates instanceof SdkAutoConstructList);
    }

    public final List<ActionState> actionStates() {
        return this.actionStates;
    }

    public final StageExecution latestExecution() {
        return this.latestExecution;
    }

    public final StageConditionState beforeEntryConditionState() {
        return this.beforeEntryConditionState;
    }

    public final StageConditionState onSuccessConditionState() {
        return this.onSuccessConditionState;
    }

    public final StageConditionState onFailureConditionState() {
        return this.onFailureConditionState;
    }

    public final RetryStageMetadata retryStageMetadata() {
        return this.retryStageMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInboundExecutions() ? this.inboundExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inboundTransitionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionStates() ? this.actionStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeEntryConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.onSuccessConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.onFailureConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStageMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState)obj;
        return Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.inboundExecution(), other.inboundExecution()) && this.hasInboundExecutions() == other.hasInboundExecutions() && Objects.equals(this.inboundExecutions(), other.inboundExecutions()) && Objects.equals(this.inboundTransitionState(), other.inboundTransitionState()) && this.hasActionStates() == other.hasActionStates() && Objects.equals(this.actionStates(), other.actionStates()) && Objects.equals(this.latestExecution(), other.latestExecution()) && Objects.equals(this.beforeEntryConditionState(), other.beforeEntryConditionState()) && Objects.equals(this.onSuccessConditionState(), other.onSuccessConditionState()) && Objects.equals(this.onFailureConditionState(), other.onFailureConditionState()) && Objects.equals(this.retryStageMetadata(), other.retryStageMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"StageState").add("StageName", (Object)this.stageName()).add("InboundExecution", (Object)this.inboundExecution()).add("InboundExecutions", this.hasInboundExecutions() ? this.inboundExecutions() : null).add("InboundTransitionState", (Object)this.inboundTransitionState()).add("ActionStates", this.hasActionStates() ? this.actionStates() : null).add("LatestExecution", (Object)this.latestExecution()).add("BeforeEntryConditionState", (Object)this.beforeEntryConditionState()).add("OnSuccessConditionState", (Object)this.onSuccessConditionState()).add("OnFailureConditionState", (Object)this.onFailureConditionState()).add("RetryStageMetadata", (Object)this.retryStageMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "inboundExecution": {
                return Optional.ofNullable(clazz.cast(this.inboundExecution()));
            }
            case "inboundExecutions": {
                return Optional.ofNullable(clazz.cast(this.inboundExecutions()));
            }
            case "inboundTransitionState": {
                return Optional.ofNullable(clazz.cast(this.inboundTransitionState()));
            }
            case "actionStates": {
                return Optional.ofNullable(clazz.cast(this.actionStates()));
            }
            case "latestExecution": {
                return Optional.ofNullable(clazz.cast(this.latestExecution()));
            }
            case "beforeEntryConditionState": {
                return Optional.ofNullable(clazz.cast(this.beforeEntryConditionState()));
            }
            case "onSuccessConditionState": {
                return Optional.ofNullable(clazz.cast(this.onSuccessConditionState()));
            }
            case "onFailureConditionState": {
                return Optional.ofNullable(clazz.cast(this.onFailureConditionState()));
            }
            case "retryStageMetadata": {
                return Optional.ofNullable(clazz.cast(this.retryStageMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("inboundExecution", INBOUND_EXECUTION_FIELD);
        map.put("inboundExecutions", INBOUND_EXECUTIONS_FIELD);
        map.put("inboundTransitionState", INBOUND_TRANSITION_STATE_FIELD);
        map.put("actionStates", ACTION_STATES_FIELD);
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("beforeEntryConditionState", BEFORE_ENTRY_CONDITION_STATE_FIELD);
        map.put("onSuccessConditionState", ON_SUCCESS_CONDITION_STATE_FIELD);
        map.put("onFailureConditionState", ON_FAILURE_CONDITION_STATE_FIELD);
        map.put("retryStageMetadata", RETRY_STAGE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StageState, T> g) {
        return obj -> g.apply((StageState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stageName;
        private StageExecution inboundExecution;
        private List<StageExecution> inboundExecutions = DefaultSdkAutoConstructList.getInstance();
        private TransitionState inboundTransitionState;
        private List<ActionState> actionStates = DefaultSdkAutoConstructList.getInstance();
        private StageExecution latestExecution;
        private StageConditionState beforeEntryConditionState;
        private StageConditionState onSuccessConditionState;
        private StageConditionState onFailureConditionState;
        private RetryStageMetadata retryStageMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            this.stageName(model.stageName);
            this.inboundExecution(model.inboundExecution);
            this.inboundExecutions(model.inboundExecutions);
            this.inboundTransitionState(model.inboundTransitionState);
            this.actionStates(model.actionStates);
            this.latestExecution(model.latestExecution);
            this.beforeEntryConditionState(model.beforeEntryConditionState);
            this.onSuccessConditionState(model.onSuccessConditionState);
            this.onFailureConditionState(model.onFailureConditionState);
            this.retryStageMetadata(model.retryStageMetadata);
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final StageExecution.Builder getInboundExecution() {
            return this.inboundExecution != null ? this.inboundExecution.toBuilder() : null;
        }

        public final void setInboundExecution(StageExecution.BuilderImpl inboundExecution) {
            this.inboundExecution = inboundExecution != null ? inboundExecution.build() : null;
        }

        @Override
        public final Builder inboundExecution(StageExecution inboundExecution) {
            this.inboundExecution = inboundExecution;
            return this;
        }

        public final List<StageExecution.Builder> getInboundExecutions() {
            List<StageExecution.Builder> result = StageExecutionListCopier.copyToBuilder(this.inboundExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundExecutions(Collection<StageExecution.BuilderImpl> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copyFromBuilder(inboundExecutions);
        }

        @Override
        public final Builder inboundExecutions(Collection<StageExecution> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copy(inboundExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(StageExecution ... inboundExecutions) {
            this.inboundExecutions(Arrays.asList(inboundExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(Consumer<StageExecution.Builder> ... inboundExecutions) {
            this.inboundExecutions(Stream.of(inboundExecutions).map(c -> (StageExecution)((StageExecution.Builder)StageExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TransitionState.Builder getInboundTransitionState() {
            return this.inboundTransitionState != null ? this.inboundTransitionState.toBuilder() : null;
        }

        public final void setInboundTransitionState(TransitionState.BuilderImpl inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState != null ? inboundTransitionState.build() : null;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final List<ActionState.Builder> getActionStates() {
            List<ActionState.Builder> result = ActionStateListCopier.copyToBuilder(this.actionStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionStates(Collection<ActionState.BuilderImpl> actionStates) {
            this.actionStates = ActionStateListCopier.copyFromBuilder(actionStates);
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState ... actionStates) {
            this.actionStates(Arrays.asList(actionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(Consumer<ActionState.Builder> ... actionStates) {
            this.actionStates(Stream.of(actionStates).map(c -> (ActionState)((ActionState.Builder)ActionState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StageExecution.Builder getLatestExecution() {
            return this.latestExecution != null ? this.latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(StageExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final StageConditionState.Builder getBeforeEntryConditionState() {
            return this.beforeEntryConditionState != null ? this.beforeEntryConditionState.toBuilder() : null;
        }

        public final void setBeforeEntryConditionState(StageConditionState.BuilderImpl beforeEntryConditionState) {
            this.beforeEntryConditionState = beforeEntryConditionState != null ? beforeEntryConditionState.build() : null;
        }

        @Override
        public final Builder beforeEntryConditionState(StageConditionState beforeEntryConditionState) {
            this.beforeEntryConditionState = beforeEntryConditionState;
            return this;
        }

        public final StageConditionState.Builder getOnSuccessConditionState() {
            return this.onSuccessConditionState != null ? this.onSuccessConditionState.toBuilder() : null;
        }

        public final void setOnSuccessConditionState(StageConditionState.BuilderImpl onSuccessConditionState) {
            this.onSuccessConditionState = onSuccessConditionState != null ? onSuccessConditionState.build() : null;
        }

        @Override
        public final Builder onSuccessConditionState(StageConditionState onSuccessConditionState) {
            this.onSuccessConditionState = onSuccessConditionState;
            return this;
        }

        public final StageConditionState.Builder getOnFailureConditionState() {
            return this.onFailureConditionState != null ? this.onFailureConditionState.toBuilder() : null;
        }

        public final void setOnFailureConditionState(StageConditionState.BuilderImpl onFailureConditionState) {
            this.onFailureConditionState = onFailureConditionState != null ? onFailureConditionState.build() : null;
        }

        @Override
        public final Builder onFailureConditionState(StageConditionState onFailureConditionState) {
            this.onFailureConditionState = onFailureConditionState;
            return this;
        }

        public final RetryStageMetadata.Builder getRetryStageMetadata() {
            return this.retryStageMetadata != null ? this.retryStageMetadata.toBuilder() : null;
        }

        public final void setRetryStageMetadata(RetryStageMetadata.BuilderImpl retryStageMetadata) {
            this.retryStageMetadata = retryStageMetadata != null ? retryStageMetadata.build() : null;
        }

        @Override
        public final Builder retryStageMetadata(RetryStageMetadata retryStageMetadata) {
            this.retryStageMetadata = retryStageMetadata;
            return this;
        }

        public StageState build() {
            return new StageState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StageState> {
        public Builder stageName(String var1);

        public Builder inboundExecution(StageExecution var1);

        default public Builder inboundExecution(Consumer<StageExecution.Builder> inboundExecution) {
            return this.inboundExecution((StageExecution)((StageExecution.Builder)StageExecution.builder().applyMutation(inboundExecution)).build());
        }

        public Builder inboundExecutions(Collection<StageExecution> var1);

        public Builder inboundExecutions(StageExecution ... var1);

        public Builder inboundExecutions(Consumer<StageExecution.Builder> ... var1);

        public Builder inboundTransitionState(TransitionState var1);

        default public Builder inboundTransitionState(Consumer<TransitionState.Builder> inboundTransitionState) {
            return this.inboundTransitionState((TransitionState)((TransitionState.Builder)TransitionState.builder().applyMutation(inboundTransitionState)).build());
        }

        public Builder actionStates(Collection<ActionState> var1);

        public Builder actionStates(ActionState ... var1);

        public Builder actionStates(Consumer<ActionState.Builder> ... var1);

        public Builder latestExecution(StageExecution var1);

        default public Builder latestExecution(Consumer<StageExecution.Builder> latestExecution) {
            return this.latestExecution((StageExecution)((StageExecution.Builder)StageExecution.builder().applyMutation(latestExecution)).build());
        }

        public Builder beforeEntryConditionState(StageConditionState var1);

        default public Builder beforeEntryConditionState(Consumer<StageConditionState.Builder> beforeEntryConditionState) {
            return this.beforeEntryConditionState((StageConditionState)((StageConditionState.Builder)StageConditionState.builder().applyMutation(beforeEntryConditionState)).build());
        }

        public Builder onSuccessConditionState(StageConditionState var1);

        default public Builder onSuccessConditionState(Consumer<StageConditionState.Builder> onSuccessConditionState) {
            return this.onSuccessConditionState((StageConditionState)((StageConditionState.Builder)StageConditionState.builder().applyMutation(onSuccessConditionState)).build());
        }

        public Builder onFailureConditionState(StageConditionState var1);

        default public Builder onFailureConditionState(Consumer<StageConditionState.Builder> onFailureConditionState) {
            return this.onFailureConditionState((StageConditionState)((StageConditionState.Builder)StageConditionState.builder().applyMutation(onFailureConditionState)).build());
        }

        public Builder retryStageMetadata(RetryStageMetadata var1);

        default public Builder retryStageMetadata(Consumer<RetryStageMetadata.Builder> retryStageMetadata) {
            return this.retryStageMetadata((RetryStageMetadata)((RetryStageMetadata.Builder)RetryStageMetadata.builder().applyMutation(retryStageMetadata)).build());
        }
    }
}

