/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineExecutionRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, GetPipelineExecutionRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineName").getter(GetPipelineExecutionRequest.getter(GetPipelineExecutionRequest::pipelineName)).setter(GetPipelineExecutionRequest.setter(Builder::pipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineName").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(GetPipelineExecutionRequest.getter(GetPipelineExecutionRequest::pipelineExecutionId)).setter(GetPipelineExecutionRequest.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD, PIPELINE_EXECUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPipelineExecutionRequest.memberNameToFieldInitializer();
    private final String pipelineName;
    private final String pipelineExecutionId;

    private GetPipelineExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
    }

    public final String pipelineName() {
        return this.pipelineName;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineExecutionRequest)) {
            return false;
        }
        GetPipelineExecutionRequest other = (GetPipelineExecutionRequest)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId());
    }

    public final String toString() {
        return ToString.builder((String)"GetPipelineExecutionRequest").add("PipelineName", (Object)this.pipelineName()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.ofNullable(clazz.cast(this.pipelineName()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pipelineName", PIPELINE_NAME_FIELD);
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineExecutionRequest, T> g) {
        return obj -> g.apply((GetPipelineExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String pipelineName;
        private String pipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineExecutionRequest model) {
            super(model);
            this.pipelineName(model.pipelineName);
            this.pipelineExecutionId(model.pipelineExecutionId);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPipelineExecutionRequest build() {
            return new GetPipelineExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineExecutionRequest> {
        public Builder pipelineName(String var1);

        public Builder pipelineExecutionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

