/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.GitBranchFilterCriteria;
import software.amazon.awssdk.services.codepipeline.model.GitFilePathFilterCriteria;
import software.amazon.awssdk.services.codepipeline.model.GitTagFilterCriteria;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitPushFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitPushFilter> {
    private static final SdkField<GitTagFilterCriteria> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tags").getter(GitPushFilter.getter(GitPushFilter::tags)).setter(GitPushFilter.setter(Builder::tags)).constructor(GitTagFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()}).build();
    private static final SdkField<GitBranchFilterCriteria> BRANCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("branches").getter(GitPushFilter.getter(GitPushFilter::branches)).setter(GitPushFilter.setter(Builder::branches)).constructor(GitBranchFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branches").build()}).build();
    private static final SdkField<GitFilePathFilterCriteria> FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filePaths").getter(GitPushFilter.getter(GitPushFilter::filePaths)).setter(GitPushFilter.setter(Builder::filePaths)).constructor(GitFilePathFilterCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePaths").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, BRANCHES_FIELD, FILE_PATHS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tags", TAGS_FIELD);
            this.put("branches", BRANCHES_FIELD);
            this.put("filePaths", FILE_PATHS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final GitTagFilterCriteria tags;
    private final GitBranchFilterCriteria branches;
    private final GitFilePathFilterCriteria filePaths;

    private GitPushFilter(BuilderImpl builder) {
        this.tags = builder.tags;
        this.branches = builder.branches;
        this.filePaths = builder.filePaths;
    }

    public final GitTagFilterCriteria tags() {
        return this.tags;
    }

    public final GitBranchFilterCriteria branches() {
        return this.branches;
    }

    public final GitFilePathFilterCriteria filePaths() {
        return this.filePaths;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.branches());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePaths());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPushFilter)) {
            return false;
        }
        GitPushFilter other = (GitPushFilter)obj;
        return Objects.equals(this.tags(), other.tags()) && Objects.equals(this.branches(), other.branches()) && Objects.equals(this.filePaths(), other.filePaths());
    }

    public final String toString() {
        return ToString.builder((String)"GitPushFilter").add("Tags", (Object)this.tags()).add("Branches", (Object)this.branches()).add("FilePaths", (Object)this.filePaths()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "branches": {
                return Optional.ofNullable(clazz.cast(this.branches()));
            }
            case "filePaths": {
                return Optional.ofNullable(clazz.cast(this.filePaths()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GitPushFilter, T> g) {
        return obj -> g.apply((GitPushFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GitTagFilterCriteria tags;
        private GitBranchFilterCriteria branches;
        private GitFilePathFilterCriteria filePaths;

        private BuilderImpl() {
        }

        private BuilderImpl(GitPushFilter model) {
            this.tags(model.tags);
            this.branches(model.branches);
            this.filePaths(model.filePaths);
        }

        public final GitTagFilterCriteria.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(GitTagFilterCriteria.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(GitTagFilterCriteria tags) {
            this.tags = tags;
            return this;
        }

        public final GitBranchFilterCriteria.Builder getBranches() {
            return this.branches != null ? this.branches.toBuilder() : null;
        }

        public final void setBranches(GitBranchFilterCriteria.BuilderImpl branches) {
            this.branches = branches != null ? branches.build() : null;
        }

        @Override
        public final Builder branches(GitBranchFilterCriteria branches) {
            this.branches = branches;
            return this;
        }

        public final GitFilePathFilterCriteria.Builder getFilePaths() {
            return this.filePaths != null ? this.filePaths.toBuilder() : null;
        }

        public final void setFilePaths(GitFilePathFilterCriteria.BuilderImpl filePaths) {
            this.filePaths = filePaths != null ? filePaths.build() : null;
        }

        @Override
        public final Builder filePaths(GitFilePathFilterCriteria filePaths) {
            this.filePaths = filePaths;
            return this;
        }

        public GitPushFilter build() {
            return new GitPushFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitPushFilter> {
        public Builder tags(GitTagFilterCriteria var1);

        default public Builder tags(Consumer<GitTagFilterCriteria.Builder> tags) {
            return this.tags((GitTagFilterCriteria)((GitTagFilterCriteria.Builder)GitTagFilterCriteria.builder().applyMutation(tags)).build());
        }

        public Builder branches(GitBranchFilterCriteria var1);

        default public Builder branches(Consumer<GitBranchFilterCriteria.Builder> branches) {
            return this.branches((GitBranchFilterCriteria)((GitBranchFilterCriteria.Builder)GitBranchFilterCriteria.builder().applyMutation(branches)).build());
        }

        public Builder filePaths(GitFilePathFilterCriteria var1);

        default public Builder filePaths(Consumer<GitFilePathFilterCriteria.Builder> filePaths) {
            return this.filePaths((GitFilePathFilterCriteria)((GitFilePathFilterCriteria.Builder)GitFilePathFilterCriteria.builder().applyMutation(filePaths)).build());
        }
    }
}

