/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StageExecutionStatus {
    CANCELLED("Cancelled"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    STOPPED("Stopped"),
    STOPPING("Stopping"),
    SUCCEEDED("Succeeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StageExecutionStatus> VALUE_MAP;
    private final String value;

    private StageExecutionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StageExecutionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StageExecutionStatus> knownValues() {
        EnumSet<StageExecutionStatus> knownValues = EnumSet.allOf(StageExecutionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StageExecutionStatus.class, StageExecutionStatus::toString);
    }
}

