/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.endpoints.internal;

import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointParams;
import software.amazon.awssdk.services.codepipeline.endpoints.CodePipelineEndpointProvider;
import software.amazon.awssdk.services.codepipeline.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class CodePipelineResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        CodePipelineEndpointProvider provider = (CodePipelineEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Endpoint result = provider.resolveEndpoint(CodePipelineResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static CodePipelineEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        CodePipelineEndpointParams.Builder builder = CodePipelineEndpointParams.builder();
        CodePipelineResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        CodePipelineResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(CodePipelineEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            default: 
        }
    }

    private static void setStaticContextParams(CodePipelineEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            default: 
        }
    }
}

