/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration;
import software.amazon.awssdk.services.codepipeline.model.PipelineMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPipelineResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, GetPipelineResponse> {
    private static final SdkField<PipelineDeclaration> PIPELINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipeline").getter(GetPipelineResponse.getter(GetPipelineResponse::pipeline)).setter(GetPipelineResponse.setter(Builder::pipeline)).constructor(PipelineDeclaration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipeline").build()}).build();
    private static final SdkField<PipelineMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(GetPipelineResponse.getter(GetPipelineResponse::metadata)).setter(GetPipelineResponse.setter(Builder::metadata)).constructor(PipelineMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_FIELD, METADATA_FIELD));
    private final PipelineDeclaration pipeline;
    private final PipelineMetadata metadata;

    private GetPipelineResponse(BuilderImpl builder) {
        super(builder);
        this.pipeline = builder.pipeline;
        this.metadata = builder.metadata;
    }

    public final PipelineDeclaration pipeline() {
        return this.pipeline;
    }

    public final PipelineMetadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipeline());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineResponse)) {
            return false;
        }
        GetPipelineResponse other = (GetPipelineResponse)((Object)obj);
        return Objects.equals(this.pipeline(), other.pipeline()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"GetPipelineResponse").add("Pipeline", (Object)this.pipeline()).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipeline": {
                return Optional.ofNullable(clazz.cast(this.pipeline()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPipelineResponse, T> g) {
        return obj -> g.apply((GetPipelineResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private PipelineDeclaration pipeline;
        private PipelineMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineResponse model) {
            super(model);
            this.pipeline(model.pipeline);
            this.metadata(model.metadata);
        }

        public final PipelineDeclaration.Builder getPipeline() {
            return this.pipeline != null ? this.pipeline.toBuilder() : null;
        }

        public final void setPipeline(PipelineDeclaration.BuilderImpl pipeline) {
            this.pipeline = pipeline != null ? pipeline.build() : null;
        }

        @Override
        @Transient
        public final Builder pipeline(PipelineDeclaration pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public final PipelineMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(PipelineMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(PipelineMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public GetPipelineResponse build() {
            return new GetPipelineResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPipelineResponse> {
        public Builder pipeline(PipelineDeclaration var1);

        default public Builder pipeline(Consumer<PipelineDeclaration.Builder> pipeline) {
            return this.pipeline((PipelineDeclaration)((PipelineDeclaration.Builder)PipelineDeclaration.builder().applyMutation(pipeline)).build());
        }

        public Builder metadata(PipelineMetadata var1);

        default public Builder metadata(Consumer<PipelineMetadata.Builder> metadata) {
            return this.metadata((PipelineMetadata)((PipelineMetadata.Builder)PipelineMetadata.builder().applyMutation(metadata)).build());
        }
    }
}

