/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActionCategory {
    SOURCE("Source"),
    BUILD("Build"),
    DEPLOY("Deploy"),
    TEST("Test"),
    INVOKE("Invoke"),
    APPROVAL("Approval"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActionCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActionCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCategory> knownValues() {
        return Stream.of(ActionCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

