/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(JobDetails.getter(JobDetails::id)).setter(JobDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<JobData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(JobDetails.getter(JobDetails::data)).setter(JobDetails.setter(Builder::data)).constructor(JobData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(JobDetails.getter(JobDetails::accountId)).setter(JobDetails.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD, ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final JobData data;
    private final String accountId;

    private JobDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.accountId = builder.accountId;
    }

    public String id() {
        return this.id;
    }

    public JobData data() {
        return this.data;
    }

    public String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.accountId(), other.accountId());
    }

    public String toString() {
        return ToString.builder((String)"JobDetails").add("Id", (Object)this.id()).add("Data", (Object)this.data()).add("AccountId", (Object)this.accountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private JobData data;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            this.id(model.id);
            this.data(model.data);
            this.accountId(model.accountId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final JobData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        @Override
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public JobDetails build() {
            return new JobDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetails> {
        public Builder id(String var1);

        public Builder data(JobData var1);

        default public Builder data(Consumer<JobData.Builder> data) {
            return this.data((JobData)((JobData.Builder)JobData.builder().applyMutation(data)).build());
        }

        public Builder accountId(String var1);
    }
}

