/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArtifactRevision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArtifactRevision> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ArtifactRevision.getter(ArtifactRevision::name)).setter(ArtifactRevision.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(ArtifactRevision.getter(ArtifactRevision::revisionId)).setter(ArtifactRevision.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> REVISION_CHANGE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionChangeIdentifier").getter(ArtifactRevision.getter(ArtifactRevision::revisionChangeIdentifier)).setter(ArtifactRevision.setter(Builder::revisionChangeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionChangeIdentifier").build()}).build();
    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionSummary").getter(ArtifactRevision.getter(ArtifactRevision::revisionSummary)).setter(ArtifactRevision.setter(Builder::revisionSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("created").getter(ArtifactRevision.getter(ArtifactRevision::created)).setter(ArtifactRevision.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()}).build();
    private static final SdkField<String> REVISION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionUrl").getter(ArtifactRevision.getter(ArtifactRevision::revisionUrl)).setter(ArtifactRevision.setter(Builder::revisionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REVISION_ID_FIELD, REVISION_CHANGE_IDENTIFIER_FIELD, REVISION_SUMMARY_FIELD, CREATED_FIELD, REVISION_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String revisionId;
    private final String revisionChangeIdentifier;
    private final String revisionSummary;
    private final Instant created;
    private final String revisionUrl;

    private ArtifactRevision(BuilderImpl builder) {
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.revisionChangeIdentifier = builder.revisionChangeIdentifier;
        this.revisionSummary = builder.revisionSummary;
        this.created = builder.created;
        this.revisionUrl = builder.revisionUrl;
    }

    public String name() {
        return this.name;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionChangeIdentifier() {
        return this.revisionChangeIdentifier;
    }

    public String revisionSummary() {
        return this.revisionSummary;
    }

    public Instant created() {
        return this.created;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionChangeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactRevision)) {
            return false;
        }
        ArtifactRevision other = (ArtifactRevision)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.revisionChangeIdentifier(), other.revisionChangeIdentifier()) && Objects.equals(this.revisionSummary(), other.revisionSummary()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public String toString() {
        return ToString.builder((String)"ArtifactRevision").add("Name", (Object)this.name()).add("RevisionId", (Object)this.revisionId()).add("RevisionChangeIdentifier", (Object)this.revisionChangeIdentifier()).add("RevisionSummary", (Object)this.revisionSummary()).add("Created", (Object)this.created()).add("RevisionUrl", (Object)this.revisionUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "revisionChangeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.revisionChangeIdentifier()));
            }
            case "revisionSummary": {
                return Optional.ofNullable(clazz.cast(this.revisionSummary()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "revisionUrl": {
                return Optional.ofNullable(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactRevision, T> g) {
        return obj -> g.apply((ArtifactRevision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String revisionId;
        private String revisionChangeIdentifier;
        private String revisionSummary;
        private Instant created;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactRevision model) {
            this.name(model.name);
            this.revisionId(model.revisionId);
            this.revisionChangeIdentifier(model.revisionChangeIdentifier);
            this.revisionSummary(model.revisionSummary);
            this.created(model.created);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionChangeIdentifier() {
            return this.revisionChangeIdentifier;
        }

        @Override
        public final Builder revisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
            return this;
        }

        public final void setRevisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public ArtifactRevision build() {
            return new ArtifactRevision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArtifactRevision> {
        public Builder name(String var1);

        public Builder revisionId(String var1);

        public Builder revisionChangeIdentifier(String var1);

        public Builder revisionSummary(String var1);

        public Builder created(Instant var1);

        public Builder revisionUrl(String var1);
    }
}

