/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response to a <code>PollForThirdPartyJobs</code> request returned by AWS CodePipeline when there is a job to be
 * worked on by a partner action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThirdPartyJob implements SdkPojo, Serializable, ToCopyableBuilder<ThirdPartyJob.Builder, ThirdPartyJob> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThirdPartyJob::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ThirdPartyJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, JOB_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String jobId;

    private ThirdPartyJob(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.jobId = builder.jobId;
    }

    /**
     * <p>
     * The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to
     * verify that the calling entity is allowed access to the job and its details.
     * </p>
     * 
     * @return The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used
     *         to verify that the calling entity is allowed access to the job and its details.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The identifier used to identify the job in AWS CodePipeline.
     * </p>
     * 
     * @return The identifier used to identify the job in AWS CodePipeline.
     */
    public String jobId() {
        return jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyJob)) {
            return false;
        }
        ThirdPartyJob other = (ThirdPartyJob) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(jobId(), other.jobId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ThirdPartyJob").add("ClientId", clientId()).add("JobId", jobId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThirdPartyJob, T> g) {
        return obj -> g.apply((ThirdPartyJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThirdPartyJob> {
        /**
         * <p>
         * The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair used to
         * verify that the calling entity is allowed access to the job and its details.
         * </p>
         * 
         * @param clientId
         *        The <code>clientToken</code> portion of the <code>clientId</code> and <code>clientToken</code> pair
         *        used to verify that the calling entity is allowed access to the job and its details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The identifier used to identify the job in AWS CodePipeline.
         * </p>
         * 
         * @param jobId
         *        The identifier used to identify the job in AWS CodePipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartyJob model) {
            clientId(model.clientId);
            jobId(model.jobId);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public ThirdPartyJob build() {
            return new ThirdPartyJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
