/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the S3 bucket that contains a revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ArtifactLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ArtifactLocation.Builder, S3ArtifactLocation> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ArtifactLocation::bucketName)).setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()).build();

    private static final SdkField<String> OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(S3ArtifactLocation::objectKey)).setter(setter(Builder::objectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD,
            OBJECT_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketName;

    private final String objectKey;

    private S3ArtifactLocation(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.objectKey = builder.objectKey;
    }

    /**
     * <p>
     * The name of the S3 bucket.
     * </p>
     * 
     * @return The name of the S3 bucket.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.
     * </p>
     * 
     * @return The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.
     */
    public String objectKey() {
        return objectKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(objectKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ArtifactLocation)) {
            return false;
        }
        S3ArtifactLocation other = (S3ArtifactLocation) obj;
        return Objects.equals(bucketName(), other.bucketName()) && Objects.equals(objectKey(), other.objectKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3ArtifactLocation").add("BucketName", bucketName()).add("ObjectKey", objectKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "objectKey":
            return Optional.ofNullable(clazz.cast(objectKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ArtifactLocation, T> g) {
        return obj -> g.apply((S3ArtifactLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ArtifactLocation> {
        /**
         * <p>
         * The name of the S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The name of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.
         * </p>
         * 
         * @param objectKey
         *        The key of the object in the S3 bucket, which uniquely identifies the object in the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectKey(String objectKey);
    }

    static final class BuilderImpl implements Builder {
        private String bucketName;

        private String objectKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ArtifactLocation model) {
            bucketName(model.bucketName);
            objectKey(model.objectKey);
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getObjectKey() {
            return objectKey;
        }

        @Override
        public final Builder objectKey(String objectKey) {
            this.objectKey = objectKey;
            return this;
        }

        public final void setObjectKey(String objectKey) {
            this.objectKey = objectKey;
        }

        @Override
        public S3ArtifactLocation build() {
            return new S3ArtifactLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
