/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PutJobSuccessResult</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutJobSuccessResultRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PutJobSuccessResultRequest.Builder, PutJobSuccessResultRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutJobSuccessResultRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<CurrentRevision> CURRENT_REVISION_FIELD = SdkField
            .<CurrentRevision> builder(MarshallingType.SDK_POJO).getter(getter(PutJobSuccessResultRequest::currentRevision))
            .setter(setter(Builder::currentRevision)).constructor(CurrentRevision::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentRevision").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutJobSuccessResultRequest::continuationToken)).setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuationToken").build()).build();

    private static final SdkField<ExecutionDetails> EXECUTION_DETAILS_FIELD = SdkField
            .<ExecutionDetails> builder(MarshallingType.SDK_POJO).getter(getter(PutJobSuccessResultRequest::executionDetails))
            .setter(setter(Builder::executionDetails)).constructor(ExecutionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build()).build();

    private static final SdkField<Map<String, String>> OUTPUT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(PutJobSuccessResultRequest::outputVariables))
            .setter(setter(Builder::outputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            CURRENT_REVISION_FIELD, CONTINUATION_TOKEN_FIELD, EXECUTION_DETAILS_FIELD, OUTPUT_VARIABLES_FIELD));

    private final String jobId;

    private final CurrentRevision currentRevision;

    private final String continuationToken;

    private final ExecutionDetails executionDetails;

    private final Map<String, String> outputVariables;

    private PutJobSuccessResultRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.currentRevision = builder.currentRevision;
        this.continuationToken = builder.continuationToken;
        this.executionDetails = builder.executionDetails;
        this.outputVariables = builder.outputVariables;
    }

    /**
     * <p>
     * The unique system-generated ID of the job that succeeded. This is the same ID returned from
     * <code>PollForJobs</code>.
     * </p>
     * 
     * @return The unique system-generated ID of the job that succeeded. This is the same ID returned from
     *         <code>PollForJobs</code>.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The ID of the current revision of the artifact successfully worked on by the job.
     * </p>
     * 
     * @return The ID of the current revision of the artifact successfully worked on by the job.
     */
    public CurrentRevision currentRevision() {
        return currentRevision;
    }

    /**
     * <p>
     * A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to
     * identify a custom action in progress. Future jobs use this token to identify the running instance of the action.
     * It can be reused to return more information about the progress of the custom action. When the action is complete,
     * no continuation token should be supplied.
     * </p>
     * 
     * @return A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job
     *         provides to identify a custom action in progress. Future jobs use this token to identify the running
     *         instance of the action. It can be reused to return more information about the progress of the custom
     *         action. When the action is complete, no continuation token should be supplied.
     */
    public String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * The execution details of the successful job, such as the actions taken by the job worker.
     * </p>
     * 
     * @return The execution details of the successful job, such as the actions taken by the job worker.
     */
    public ExecutionDetails executionDetails() {
        return executionDetails;
    }

    /**
     * Returns true if the OutputVariables property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOutputVariables() {
        return outputVariables != null && !(outputVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs produced as output by a job worker that can be made available to a downstream action
     * configuration. <code>outputVariables</code> can be included only when there is no continuation token on the
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Key-value pairs produced as output by a job worker that can be made available to a downstream action
     *         configuration. <code>outputVariables</code> can be included only when there is no continuation token on
     *         the request.
     */
    public Map<String, String> outputVariables() {
        return outputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(currentRevision());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(executionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(outputVariables());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutJobSuccessResultRequest)) {
            return false;
        }
        PutJobSuccessResultRequest other = (PutJobSuccessResultRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(currentRevision(), other.currentRevision())
                && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(executionDetails(), other.executionDetails())
                && Objects.equals(outputVariables(), other.outputVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutJobSuccessResultRequest").add("JobId", jobId()).add("CurrentRevision", currentRevision())
                .add("ContinuationToken", continuationToken()).add("ExecutionDetails", executionDetails())
                .add("OutputVariables", outputVariables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "currentRevision":
            return Optional.ofNullable(clazz.cast(currentRevision()));
        case "continuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "executionDetails":
            return Optional.ofNullable(clazz.cast(executionDetails()));
        case "outputVariables":
            return Optional.ofNullable(clazz.cast(outputVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutJobSuccessResultRequest, T> g) {
        return obj -> g.apply((PutJobSuccessResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutJobSuccessResultRequest> {
        /**
         * <p>
         * The unique system-generated ID of the job that succeeded. This is the same ID returned from
         * <code>PollForJobs</code>.
         * </p>
         * 
         * @param jobId
         *        The unique system-generated ID of the job that succeeded. This is the same ID returned from
         *        <code>PollForJobs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * 
         * @param currentRevision
         *        The ID of the current revision of the artifact successfully worked on by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRevision(CurrentRevision currentRevision);

        /**
         * <p>
         * The ID of the current revision of the artifact successfully worked on by the job.
         * </p>
         * This is a convenience that creates an instance of the {@link CurrentRevision.Builder} avoiding the need to
         * create one manually via {@link CurrentRevision#builder()}.
         *
         * When the {@link Consumer} completes, {@link CurrentRevision.Builder#build()} is called immediately and its
         * result is passed to {@link #currentRevision(CurrentRevision)}.
         * 
         * @param currentRevision
         *        a consumer that will call methods on {@link CurrentRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentRevision(CurrentRevision)
         */
        default Builder currentRevision(Consumer<CurrentRevision.Builder> currentRevision) {
            return currentRevision(CurrentRevision.builder().applyMutation(currentRevision).build());
        }

        /**
         * <p>
         * A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job provides to
         * identify a custom action in progress. Future jobs use this token to identify the running instance of the
         * action. It can be reused to return more information about the progress of the custom action. When the action
         * is complete, no continuation token should be supplied.
         * </p>
         * 
         * @param continuationToken
         *        A token generated by a job worker, such as an AWS CodeDeploy deployment ID, that a successful job
         *        provides to identify a custom action in progress. Future jobs use this token to identify the running
         *        instance of the action. It can be reused to return more information about the progress of the custom
         *        action. When the action is complete, no continuation token should be supplied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * The execution details of the successful job, such as the actions taken by the job worker.
         * </p>
         * 
         * @param executionDetails
         *        The execution details of the successful job, such as the actions taken by the job worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionDetails(ExecutionDetails executionDetails);

        /**
         * <p>
         * The execution details of the successful job, such as the actions taken by the job worker.
         * </p>
         * This is a convenience that creates an instance of the {@link ExecutionDetails.Builder} avoiding the need to
         * create one manually via {@link ExecutionDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExecutionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #executionDetails(ExecutionDetails)}.
         * 
         * @param executionDetails
         *        a consumer that will call methods on {@link ExecutionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionDetails(ExecutionDetails)
         */
        default Builder executionDetails(Consumer<ExecutionDetails.Builder> executionDetails) {
            return executionDetails(ExecutionDetails.builder().applyMutation(executionDetails).build());
        }

        /**
         * <p>
         * Key-value pairs produced as output by a job worker that can be made available to a downstream action
         * configuration. <code>outputVariables</code> can be included only when there is no continuation token on the
         * request.
         * </p>
         * 
         * @param outputVariables
         *        Key-value pairs produced as output by a job worker that can be made available to a downstream action
         *        configuration. <code>outputVariables</code> can be included only when there is no continuation token
         *        on the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputVariables(Map<String, String> outputVariables);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private String jobId;

        private CurrentRevision currentRevision;

        private String continuationToken;

        private ExecutionDetails executionDetails;

        private Map<String, String> outputVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutJobSuccessResultRequest model) {
            super(model);
            jobId(model.jobId);
            currentRevision(model.currentRevision);
            continuationToken(model.continuationToken);
            executionDetails(model.executionDetails);
            outputVariables(model.outputVariables);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final CurrentRevision.Builder getCurrentRevision() {
            return currentRevision != null ? currentRevision.toBuilder() : null;
        }

        @Override
        public final Builder currentRevision(CurrentRevision currentRevision) {
            this.currentRevision = currentRevision;
            return this;
        }

        public final void setCurrentRevision(CurrentRevision.BuilderImpl currentRevision) {
            this.currentRevision = currentRevision != null ? currentRevision.build() : null;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        public final ExecutionDetails.Builder getExecutionDetails() {
            return executionDetails != null ? executionDetails.toBuilder() : null;
        }

        @Override
        public final Builder executionDetails(ExecutionDetails executionDetails) {
            this.executionDetails = executionDetails;
            return this;
        }

        public final void setExecutionDetails(ExecutionDetails.BuilderImpl executionDetails) {
            this.executionDetails = executionDetails != null ? executionDetails.build() : null;
        }

        public final Map<String, String> getOutputVariables() {
            return outputVariables;
        }

        @Override
        public final Builder outputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
            return this;
        }

        public final void setOutputVariables(Map<String, String> outputVariables) {
            this.outputVariables = OutputVariablesMapCopier.copy(outputVariables);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutJobSuccessResultRequest build() {
            return new PutJobSuccessResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
