/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebhooksResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListWebhooksResponse.Builder, ListWebhooksResponse> {
    private static final SdkField<List<ListWebhookItem>> WEBHOOKS_FIELD = SdkField
            .<List<ListWebhookItem>> builder(MarshallingType.LIST)
            .getter(getter(ListWebhooksResponse::webhooks))
            .setter(setter(Builder::webhooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListWebhookItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListWebhookItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebhooksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ListWebhookItem> webhooks;

    private final String nextToken;

    private ListWebhooksResponse(BuilderImpl builder) {
        super(builder);
        this.webhooks = builder.webhooks;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Webhooks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWebhooks() {
        return webhooks != null && !(webhooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The JSON detail returned for each webhook in the list output for the ListWebhooks call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWebhooks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The JSON detail returned for each webhook in the list output for the ListWebhooks call.
     */
    public List<ListWebhookItem> webhooks() {
        return webhooks;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an identifier is also returned and can be used in a
     * subsequent ListWebhooks call to return the next set of webhooks in the list.
     * </p>
     * 
     * @return If the amount of returned information is significantly large, an identifier is also returned and can be
     *         used in a subsequent ListWebhooks call to return the next set of webhooks in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webhooks());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhooksResponse)) {
            return false;
        }
        ListWebhooksResponse other = (ListWebhooksResponse) obj;
        return Objects.equals(webhooks(), other.webhooks()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWebhooksResponse").add("Webhooks", webhooks()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webhooks":
            return Optional.ofNullable(clazz.cast(webhooks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebhooksResponse, T> g) {
        return obj -> g.apply((ListWebhooksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWebhooksResponse> {
        /**
         * <p>
         * The JSON detail returned for each webhook in the list output for the ListWebhooks call.
         * </p>
         * 
         * @param webhooks
         *        The JSON detail returned for each webhook in the list output for the ListWebhooks call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhooks(Collection<ListWebhookItem> webhooks);

        /**
         * <p>
         * The JSON detail returned for each webhook in the list output for the ListWebhooks call.
         * </p>
         * 
         * @param webhooks
         *        The JSON detail returned for each webhook in the list output for the ListWebhooks call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhooks(ListWebhookItem... webhooks);

        /**
         * <p>
         * The JSON detail returned for each webhook in the list output for the ListWebhooks call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ListWebhookItem>.Builder} avoiding the need
         * to create one manually via {@link List<ListWebhookItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListWebhookItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #webhooks(List<ListWebhookItem>)}.
         * 
         * @param webhooks
         *        a consumer that will call methods on {@link List<ListWebhookItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webhooks(List<ListWebhookItem>)
         */
        Builder webhooks(Consumer<ListWebhookItem.Builder>... webhooks);

        /**
         * <p>
         * If the amount of returned information is significantly large, an identifier is also returned and can be used
         * in a subsequent ListWebhooks call to return the next set of webhooks in the list.
         * </p>
         * 
         * @param nextToken
         *        If the amount of returned information is significantly large, an identifier is also returned and can
         *        be used in a subsequent ListWebhooks call to return the next set of webhooks in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<ListWebhookItem> webhooks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhooksResponse model) {
            super(model);
            webhooks(model.webhooks);
            nextToken(model.nextToken);
        }

        public final Collection<ListWebhookItem.Builder> getWebhooks() {
            return webhooks != null ? webhooks.stream().map(ListWebhookItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder webhooks(Collection<ListWebhookItem> webhooks) {
            this.webhooks = WebhookListCopier.copy(webhooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhooks(ListWebhookItem... webhooks) {
            webhooks(Arrays.asList(webhooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhooks(Consumer<ListWebhookItem.Builder>... webhooks) {
            webhooks(Stream.of(webhooks).map(c -> ListWebhookItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWebhooks(Collection<ListWebhookItem.BuilderImpl> webhooks) {
            this.webhooks = WebhookListCopier.copyFromBuilder(webhooks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWebhooksResponse build() {
            return new ListWebhooksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
