/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>ListActionTypes</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListActionTypesResponse extends CodePipelineResponse implements
        ToCopyableBuilder<ListActionTypesResponse.Builder, ListActionTypesResponse> {
    private static final SdkField<List<ActionType>> ACTION_TYPES_FIELD = SdkField
            .<List<ActionType>> builder(MarshallingType.LIST)
            .getter(getter(ListActionTypesResponse::actionTypes))
            .setter(setter(Builder::actionTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionType> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListActionTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ActionType> actionTypes;

    private final String nextToken;

    private ListActionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.actionTypes = builder.actionTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ActionTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActionTypes() {
        return actionTypes != null && !(actionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides details of the action types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActionTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides details of the action types.
     */
    public List<ActionType> actionTypes() {
        return actionTypes;
    }

    /**
     * <p>
     * If the amount of returned information is significantly large, an identifier is also returned. It can be used in a
     * subsequent list action types call to return the next set of action types in the list.
     * </p>
     * 
     * @return If the amount of returned information is significantly large, an identifier is also returned. It can be
     *         used in a subsequent list action types call to return the next set of action types in the list.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesResponse)) {
            return false;
        }
        ListActionTypesResponse other = (ListActionTypesResponse) obj;
        return Objects.equals(actionTypes(), other.actionTypes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListActionTypesResponse").add("ActionTypes", actionTypes()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypes":
            return Optional.ofNullable(clazz.cast(actionTypes()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListActionTypesResponse, T> g) {
        return obj -> g.apply((ListActionTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListActionTypesResponse> {
        /**
         * <p>
         * Provides details of the action types.
         * </p>
         * 
         * @param actionTypes
         *        Provides details of the action types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypes(Collection<ActionType> actionTypes);

        /**
         * <p>
         * Provides details of the action types.
         * </p>
         * 
         * @param actionTypes
         *        Provides details of the action types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypes(ActionType... actionTypes);

        /**
         * <p>
         * Provides details of the action types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ActionType>.Builder} avoiding the need to
         * create one manually via {@link List<ActionType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ActionType>.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypes(List<ActionType>)}.
         * 
         * @param actionTypes
         *        a consumer that will call methods on {@link List<ActionType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypes(List<ActionType>)
         */
        Builder actionTypes(Consumer<ActionType.Builder>... actionTypes);

        /**
         * <p>
         * If the amount of returned information is significantly large, an identifier is also returned. It can be used
         * in a subsequent list action types call to return the next set of action types in the list.
         * </p>
         * 
         * @param nextToken
         *        If the amount of returned information is significantly large, an identifier is also returned. It can
         *        be used in a subsequent list action types call to return the next set of action types in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<ActionType> actionTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesResponse model) {
            super(model);
            actionTypes(model.actionTypes);
            nextToken(model.nextToken);
        }

        public final Collection<ActionType.Builder> getActionTypes() {
            return actionTypes != null ? actionTypes.stream().map(ActionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionTypes(Collection<ActionType> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copy(actionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(ActionType... actionTypes) {
            actionTypes(Arrays.asList(actionTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(Consumer<ActionType.Builder>... actionTypes) {
            actionTypes(Stream.of(actionTypes).map(c -> ActionType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setActionTypes(Collection<ActionType.BuilderImpl> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copyFromBuilder(actionTypes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListActionTypesResponse build() {
            return new ListActionTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
