/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about a current revision.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentRevision implements SdkPojo, Serializable, ToCopyableBuilder<CurrentRevision.Builder, CurrentRevision> {
    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CurrentRevision::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final SdkField<String> CHANGE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CurrentRevision::changeIdentifier)).setter(setter(Builder::changeIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeIdentifier").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CurrentRevision::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<String> REVISION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CurrentRevision::revisionSummary)).setter(setter(Builder::revisionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_FIELD,
            CHANGE_IDENTIFIER_FIELD, CREATED_FIELD, REVISION_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String revision;

    private final String changeIdentifier;

    private final Instant created;

    private final String revisionSummary;

    private CurrentRevision(BuilderImpl builder) {
        this.revision = builder.revision;
        this.changeIdentifier = builder.changeIdentifier;
        this.created = builder.created;
        this.revisionSummary = builder.revisionSummary;
    }

    /**
     * <p>
     * The revision ID of the current version of an artifact.
     * </p>
     * 
     * @return The revision ID of the current version of an artifact.
     */
    public String revision() {
        return revision;
    }

    /**
     * <p>
     * The change identifier for the current revision.
     * </p>
     * 
     * @return The change identifier for the current revision.
     */
    public String changeIdentifier() {
        return changeIdentifier;
    }

    /**
     * <p>
     * The date and time when the most recent revision of the artifact was created, in timestamp format.
     * </p>
     * 
     * @return The date and time when the most recent revision of the artifact was created, in timestamp format.
     */
    public Instant created() {
        return created;
    }

    /**
     * <p>
     * The summary of the most recent revision of the artifact.
     * </p>
     * 
     * @return The summary of the most recent revision of the artifact.
     */
    public String revisionSummary() {
        return revisionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(changeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(revisionSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentRevision)) {
            return false;
        }
        CurrentRevision other = (CurrentRevision) obj;
        return Objects.equals(revision(), other.revision()) && Objects.equals(changeIdentifier(), other.changeIdentifier())
                && Objects.equals(created(), other.created()) && Objects.equals(revisionSummary(), other.revisionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CurrentRevision").add("Revision", revision()).add("ChangeIdentifier", changeIdentifier())
                .add("Created", created()).add("RevisionSummary", revisionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "changeIdentifier":
            return Optional.ofNullable(clazz.cast(changeIdentifier()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "revisionSummary":
            return Optional.ofNullable(clazz.cast(revisionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentRevision, T> g) {
        return obj -> g.apply((CurrentRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentRevision> {
        /**
         * <p>
         * The revision ID of the current version of an artifact.
         * </p>
         * 
         * @param revision
         *        The revision ID of the current version of an artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        /**
         * <p>
         * The change identifier for the current revision.
         * </p>
         * 
         * @param changeIdentifier
         *        The change identifier for the current revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeIdentifier(String changeIdentifier);

        /**
         * <p>
         * The date and time when the most recent revision of the artifact was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time when the most recent revision of the artifact was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The summary of the most recent revision of the artifact.
         * </p>
         * 
         * @param revisionSummary
         *        The summary of the most recent revision of the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionSummary(String revisionSummary);
    }

    static final class BuilderImpl implements Builder {
        private String revision;

        private String changeIdentifier;

        private Instant created;

        private String revisionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentRevision model) {
            revision(model.revision);
            changeIdentifier(model.changeIdentifier);
            created(model.created);
            revisionSummary(model.revisionSummary);
        }

        public final String getRevision() {
            return revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        public final String getChangeIdentifier() {
            return changeIdentifier;
        }

        @Override
        public final Builder changeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
            return this;
        }

        public final void setChangeIdentifier(String changeIdentifier) {
            this.changeIdentifier = changeIdentifier;
        }

        public final Instant getCreated() {
            return created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getRevisionSummary() {
            return revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        @Override
        public CurrentRevision build() {
            return new CurrentRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
