/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Input information used for an action execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionInput.Builder, ActionExecutionInput> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .getter(getter(ActionExecutionInput::actionTypeId)).setter(setter(Builder::actionTypeId))
            .constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()).build();

    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ActionExecutionInput::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> RESOLVED_CONFIGURATION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ActionExecutionInput::resolvedConfiguration))
            .setter(setter(Builder::resolvedConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionInput::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionInput::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<ArtifactDetail>> INPUT_ARTIFACTS_FIELD = SdkField
            .<List<ArtifactDetail>> builder(MarshallingType.LIST)
            .getter(getter(ActionExecutionInput::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArtifactDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ActionExecutionInput::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD,
            CONFIGURATION_FIELD, RESOLVED_CONFIGURATION_FIELD, ROLE_ARN_FIELD, REGION_FIELD, INPUT_ARTIFACTS_FIELD,
            NAMESPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActionTypeId actionTypeId;

    private final Map<String, String> configuration;

    private final Map<String, String> resolvedConfiguration;

    private final String roleArn;

    private final String region;

    private final List<ArtifactDetail> inputArtifacts;

    private final String namespace;

    private ActionExecutionInput(BuilderImpl builder) {
        this.actionTypeId = builder.actionTypeId;
        this.configuration = builder.configuration;
        this.resolvedConfiguration = builder.resolvedConfiguration;
        this.roleArn = builder.roleArn;
        this.region = builder.region;
        this.inputArtifacts = builder.inputArtifacts;
        this.namespace = builder.namespace;
    }

    /**
     * Returns the value of the ActionTypeId property for this object.
     * 
     * @return The value of the ActionTypeId property for this object.
     */
    public ActionTypeId actionTypeId() {
        return actionTypeId;
    }

    /**
     * Returns true if the Configuration property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration data for an action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration data for an action execution.
     */
    public Map<String, String> configuration() {
        return configuration;
    }

    /**
     * Returns true if the ResolvedConfiguration property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasResolvedConfiguration() {
        return resolvedConfiguration != null && !(resolvedConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Configuration data for an action execution with all variable references replaced with their real values for the
     * execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResolvedConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration data for an action execution with all variable references replaced with their real values
     *         for the execution.
     */
    public Map<String, String> resolvedConfiguration() {
        return resolvedConfiguration;
    }

    /**
     * <p>
     * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for the
     * pipeline.
     * </p>
     * 
     * @return The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn
     *         for the pipeline.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The AWS Region for the action, such as us-east-1.
     * </p>
     * 
     * @return The AWS Region for the action, such as us-east-1.
     */
    public String region() {
        return region;
    }

    /**
     * Returns true if the InputArtifacts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details of input artifacts of the action that correspond to the action execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details of input artifacts of the action that correspond to the action execution.
     */
    public List<ArtifactDetail> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * <p>
     * The variable namespace associated with the action. All variables produced as output by this action fall under
     * this namespace.
     * </p>
     * 
     * @return The variable namespace associated with the action. All variables produced as output by this action fall
     *         under this namespace.
     */
    public String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionInput)) {
            return false;
        }
        ActionExecutionInput other = (ActionExecutionInput) obj;
        return Objects.equals(actionTypeId(), other.actionTypeId()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(resolvedConfiguration(), other.resolvedConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(region(), other.region())
                && Objects.equals(inputArtifacts(), other.inputArtifacts()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ActionExecutionInput").add("ActionTypeId", actionTypeId()).add("Configuration", configuration())
                .add("ResolvedConfiguration", resolvedConfiguration()).add("RoleArn", roleArn()).add("Region", region())
                .add("InputArtifacts", inputArtifacts()).add("Namespace", namespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypeId":
            return Optional.ofNullable(clazz.cast(actionTypeId()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "resolvedConfiguration":
            return Optional.ofNullable(clazz.cast(resolvedConfiguration()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "inputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionInput, T> g) {
        return obj -> g.apply((ActionExecutionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionInput> {
        /**
         * Sets the value of the ActionTypeId property for this object.
         *
         * @param actionTypeId
         *        The new value for the ActionTypeId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypeId(ActionTypeId actionTypeId);

        /**
         * Sets the value of the ActionTypeId property for this object.
         *
         * This is a convenience that creates an instance of the {@link ActionTypeId.Builder} avoiding the need to
         * create one manually via {@link ActionTypeId#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypeId(ActionTypeId)}.
         * 
         * @param actionTypeId
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypeId(ActionTypeId)
         */
        default Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return actionTypeId(ActionTypeId.builder().applyMutation(actionTypeId).build());
        }

        /**
         * <p>
         * Configuration data for an action execution.
         * </p>
         * 
         * @param configuration
         *        Configuration data for an action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Map<String, String> configuration);

        /**
         * <p>
         * Configuration data for an action execution with all variable references replaced with their real values for
         * the execution.
         * </p>
         * 
         * @param resolvedConfiguration
         *        Configuration data for an action execution with all variable references replaced with their real
         *        values for the execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedConfiguration(Map<String, String> resolvedConfiguration);

        /**
         * <p>
         * The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn for
         * the pipeline.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM service role that performs the declared action. This is assumed through the roleArn
         *        for the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The AWS Region for the action, such as us-east-1.
         * </p>
         * 
         * @param region
         *        The AWS Region for the action, such as us-east-1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param inputArtifacts
         *        Details of input artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Collection<ArtifactDetail> inputArtifacts);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * 
         * @param inputArtifacts
         *        Details of input artifacts of the action that correspond to the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(ArtifactDetail... inputArtifacts);

        /**
         * <p>
         * Details of input artifacts of the action that correspond to the action execution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ArtifactDetail>.Builder} avoiding the need
         * to create one manually via {@link List<ArtifactDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ArtifactDetail>.Builder#build()} is called immediately and
         * its result is passed to {@link #inputArtifacts(List<ArtifactDetail>)}.
         * 
         * @param inputArtifacts
         *        a consumer that will call methods on {@link List<ArtifactDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputArtifacts(List<ArtifactDetail>)
         */
        Builder inputArtifacts(Consumer<ArtifactDetail.Builder>... inputArtifacts);

        /**
         * <p>
         * The variable namespace associated with the action. All variables produced as output by this action fall under
         * this namespace.
         * </p>
         * 
         * @param namespace
         *        The variable namespace associated with the action. All variables produced as output by this action
         *        fall under this namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private ActionTypeId actionTypeId;

        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> resolvedConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private String roleArn;

        private String region;

        private List<ArtifactDetail> inputArtifacts = DefaultSdkAutoConstructList.getInstance();

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionInput model) {
            actionTypeId(model.actionTypeId);
            configuration(model.configuration);
            resolvedConfiguration(model.resolvedConfiguration);
            roleArn(model.roleArn);
            region(model.region);
            inputArtifacts(model.inputArtifacts);
            namespace(model.namespace);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return actionTypeId != null ? actionTypeId.toBuilder() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        public final Map<String, String> getConfiguration() {
            return configuration;
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
            return this;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = ActionConfigurationMapCopier.copy(configuration);
        }

        public final Map<String, String> getResolvedConfiguration() {
            return resolvedConfiguration;
        }

        @Override
        public final Builder resolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
            return this;
        }

        public final void setResolvedConfiguration(Map<String, String> resolvedConfiguration) {
            this.resolvedConfiguration = ResolvedActionConfigurationMapCopier.copy(resolvedConfiguration);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Collection<ArtifactDetail.Builder> getInputArtifacts() {
            return inputArtifacts != null ? inputArtifacts.stream().map(ArtifactDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder inputArtifacts(Collection<ArtifactDetail> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copy(inputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(ArtifactDetail... inputArtifacts) {
            inputArtifacts(Arrays.asList(inputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputArtifacts(Consumer<ArtifactDetail.Builder>... inputArtifacts) {
            inputArtifacts(Stream.of(inputArtifacts).map(c -> ArtifactDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputArtifacts(Collection<ArtifactDetail.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = ArtifactDetailListCopier.copyFromBuilder(inputArtifacts);
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public ActionExecutionInput build() {
            return new ActionExecutionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
