/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>PollForThirdPartyJobs</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForThirdPartyJobsResponse extends CodePipelineResponse implements
        ToCopyableBuilder<PollForThirdPartyJobsResponse.Builder, PollForThirdPartyJobsResponse> {
    private static final SdkField<List<ThirdPartyJob>> JOBS_FIELD = SdkField
            .<List<ThirdPartyJob>> builder(MarshallingType.LIST)
            .getter(getter(PollForThirdPartyJobsResponse::jobs))
            .setter(setter(Builder::jobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThirdPartyJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThirdPartyJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD));

    private final List<ThirdPartyJob> jobs;

    private PollForThirdPartyJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
    }

    /**
     * Returns true if the Jobs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasJobs() {
        return jobs != null && !(jobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the jobs to take action on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the jobs to take action on.
     */
    public List<ThirdPartyJob> jobs() {
        return jobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForThirdPartyJobsResponse)) {
            return false;
        }
        PollForThirdPartyJobsResponse other = (PollForThirdPartyJobsResponse) obj;
        return Objects.equals(jobs(), other.jobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PollForThirdPartyJobsResponse").add("Jobs", jobs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobs":
            return Optional.ofNullable(clazz.cast(jobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PollForThirdPartyJobsResponse, T> g) {
        return obj -> g.apply((PollForThirdPartyJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodePipelineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PollForThirdPartyJobsResponse> {
        /**
         * <p>
         * Information about the jobs to take action on.
         * </p>
         * 
         * @param jobs
         *        Information about the jobs to take action on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(Collection<ThirdPartyJob> jobs);

        /**
         * <p>
         * Information about the jobs to take action on.
         * </p>
         * 
         * @param jobs
         *        Information about the jobs to take action on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobs(ThirdPartyJob... jobs);

        /**
         * <p>
         * Information about the jobs to take action on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ThirdPartyJob>.Builder} avoiding the need
         * to create one manually via {@link List<ThirdPartyJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ThirdPartyJob>.Builder#build()} is called immediately and
         * its result is passed to {@link #jobs(List<ThirdPartyJob>)}.
         * 
         * @param jobs
         *        a consumer that will call methods on {@link List<ThirdPartyJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobs(List<ThirdPartyJob>)
         */
        Builder jobs(Consumer<ThirdPartyJob.Builder>... jobs);
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private List<ThirdPartyJob> jobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PollForThirdPartyJobsResponse model) {
            super(model);
            jobs(model.jobs);
        }

        public final Collection<ThirdPartyJob.Builder> getJobs() {
            return jobs != null ? jobs.stream().map(ThirdPartyJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobs(Collection<ThirdPartyJob> jobs) {
            this.jobs = ThirdPartyJobListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(ThirdPartyJob... jobs) {
            jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<ThirdPartyJob.Builder>... jobs) {
            jobs(Stream.of(jobs).map(c -> ThirdPartyJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobs(Collection<ThirdPartyJob.BuilderImpl> jobs) {
            this.jobs = ThirdPartyJobListCopier.copyFromBuilder(jobs);
        }

        @Override
        public PollForThirdPartyJobsResponse build() {
            return new PollForThirdPartyJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
