/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The detail returned for each webhook after listing webhooks, such as the webhook URL, the webhook name, and the
 * webhook ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebhookItem implements SdkPojo, Serializable, ToCopyableBuilder<ListWebhookItem.Builder, ListWebhookItem> {
    private static final SdkField<WebhookDefinition> DEFINITION_FIELD = SdkField
            .<WebhookDefinition> builder(MarshallingType.SDK_POJO).getter(getter(ListWebhookItem::definition))
            .setter(setter(Builder::definition)).constructor(WebhookDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebhookItem::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebhookItem::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebhookItem::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<Instant> LAST_TRIGGERED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListWebhookItem::lastTriggered)).setter(setter(Builder::lastTriggered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggered").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListWebhookItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(ListWebhookItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, URL_FIELD,
            ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, LAST_TRIGGERED_FIELD, ARN_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final WebhookDefinition definition;

    private final String url;

    private final String errorMessage;

    private final String errorCode;

    private final Instant lastTriggered;

    private final String arn;

    private final List<Tag> tags;

    private ListWebhookItem(BuilderImpl builder) {
        this.definition = builder.definition;
        this.url = builder.url;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.lastTriggered = builder.lastTriggered;
        this.arn = builder.arn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * </p>
     * 
     * @return The detail returned for each webhook, such as the webhook authentication type and filter rules.
     */
    public WebhookDefinition definition() {
        return definition;
    }

    /**
     * <p>
     * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started
     * as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting
     * and re-creating a webhook makes the old URL invalid and generates a new one.
     * </p>
     * 
     * @return A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is
     *         started as long as the body of the post request satisfies the defined authentication and filtering
     *         conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.
     */
    public String url() {
        return url;
    }

    /**
     * <p>
     * The text of the error message about the webhook.
     * </p>
     * 
     * @return The text of the error message about the webhook.
     */
    public String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The number code of the error.
     * </p>
     * 
     * @return The number code of the error.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The date and time a webhook was last successfully triggered, in timestamp format.
     * </p>
     * 
     * @return The date and time a webhook was last successfully triggered, in timestamp format.
     */
    public Instant lastTriggered() {
        return lastTriggered;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the webhook.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the webhook.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the tags applied to the webhook.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies the tags applied to the webhook.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(lastTriggered());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebhookItem)) {
            return false;
        }
        ListWebhookItem other = (ListWebhookItem) obj;
        return Objects.equals(definition(), other.definition()) && Objects.equals(url(), other.url())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(lastTriggered(), other.lastTriggered()) && Objects.equals(arn(), other.arn())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListWebhookItem").add("Definition", definition()).add("Url", url())
                .add("ErrorMessage", errorMessage()).add("ErrorCode", errorCode()).add("LastTriggered", lastTriggered())
                .add("Arn", arn()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "lastTriggered":
            return Optional.ofNullable(clazz.cast(lastTriggered()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebhookItem, T> g) {
        return obj -> g.apply((ListWebhookItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListWebhookItem> {
        /**
         * <p>
         * The detail returned for each webhook, such as the webhook authentication type and filter rules.
         * </p>
         * 
         * @param definition
         *        The detail returned for each webhook, such as the webhook authentication type and filter rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(WebhookDefinition definition);

        /**
         * <p>
         * The detail returned for each webhook, such as the webhook authentication type and filter rules.
         * </p>
         * This is a convenience that creates an instance of the {@link WebhookDefinition.Builder} avoiding the need to
         * create one manually via {@link WebhookDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link WebhookDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(WebhookDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link WebhookDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(WebhookDefinition)
         */
        default Builder definition(Consumer<WebhookDefinition.Builder> definition) {
            return definition(WebhookDefinition.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is
         * started as long as the body of the post request satisfies the defined authentication and filtering
         * conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.
         * </p>
         * 
         * @param url
         *        A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline
         *        is started as long as the body of the post request satisfies the defined authentication and filtering
         *        conditions. Deleting and re-creating a webhook makes the old URL invalid and generates a new one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The text of the error message about the webhook.
         * </p>
         * 
         * @param errorMessage
         *        The text of the error message about the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The number code of the error.
         * </p>
         * 
         * @param errorCode
         *        The number code of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The date and time a webhook was last successfully triggered, in timestamp format.
         * </p>
         * 
         * @param lastTriggered
         *        The date and time a webhook was last successfully triggered, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastTriggered(Instant lastTriggered);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the webhook.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the tags applied to the webhook.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Specifies the tags applied to the webhook.
         * </p>
         * 
         * @param tags
         *        Specifies the tags applied to the webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Specifies the tags applied to the webhook.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private WebhookDefinition definition;

        private String url;

        private String errorMessage;

        private String errorCode;

        private Instant lastTriggered;

        private String arn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebhookItem model) {
            definition(model.definition);
            url(model.url);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            lastTriggered(model.lastTriggered);
            arn(model.arn);
            tags(model.tags);
        }

        public final WebhookDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(WebhookDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(WebhookDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final Instant getLastTriggered() {
            return lastTriggered;
        }

        @Override
        public final Builder lastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
            return this;
        }

        public final void setLastTriggered(Instant lastTriggered) {
            this.lastTriggered = lastTriggered;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public ListWebhookItem build() {
            return new ListWebhookItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
