/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutActionRevisionResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, PutActionRevisionResponse> {
    private static final SdkField<Boolean> NEW_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PutActionRevisionResponse.getter(PutActionRevisionResponse::newRevision)).setter(PutActionRevisionResponse.setter(Builder::newRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newRevision").build()}).build();
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutActionRevisionResponse.getter(PutActionRevisionResponse::pipelineExecutionId)).setter(PutActionRevisionResponse.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_REVISION_FIELD, PIPELINE_EXECUTION_ID_FIELD));
    private final Boolean newRevision;
    private final String pipelineExecutionId;

    private PutActionRevisionResponse(BuilderImpl builder) {
        super(builder);
        this.newRevision = builder.newRevision;
        this.pipelineExecutionId = builder.pipelineExecutionId;
    }

    public Boolean newRevision() {
        return this.newRevision;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.newRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutActionRevisionResponse)) {
            return false;
        }
        PutActionRevisionResponse other = (PutActionRevisionResponse)((Object)obj);
        return Objects.equals(this.newRevision(), other.newRevision()) && Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId());
    }

    public String toString() {
        return ToString.builder((String)"PutActionRevisionResponse").add("NewRevision", (Object)this.newRevision()).add("PipelineExecutionId", (Object)this.pipelineExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "newRevision": {
                return Optional.ofNullable(clazz.cast(this.newRevision()));
            }
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutActionRevisionResponse, T> g) {
        return obj -> g.apply((PutActionRevisionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private Boolean newRevision;
        private String pipelineExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutActionRevisionResponse model) {
            super(model);
            this.newRevision(model.newRevision);
            this.pipelineExecutionId(model.pipelineExecutionId);
        }

        public final Boolean getNewRevision() {
            return this.newRevision;
        }

        @Override
        public final Builder newRevision(Boolean newRevision) {
            this.newRevision = newRevision;
            return this;
        }

        public final void setNewRevision(Boolean newRevision) {
            this.newRevision = newRevision;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public PutActionRevisionResponse build() {
            return new PutActionRevisionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutActionRevisionResponse> {
        public Builder newRevision(Boolean var1);

        public Builder pipelineExecutionId(String var1);
    }
}

