/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.transform.EncryptionKeyUnmarshaller;

public class ArtifactStoreUnmarshaller
implements Unmarshaller<ArtifactStore, JsonUnmarshallerContext> {
    private static final ArtifactStoreUnmarshaller INSTANCE = new ArtifactStoreUnmarshaller();

    public ArtifactStore unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArtifactStore.Builder artifactStoreBuilder = ArtifactStore.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    artifactStoreBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    artifactStoreBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryptionKey", targetDepth)) {
                    context.nextToken();
                    artifactStoreBuilder.encryptionKey(EncryptionKeyUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ArtifactStore)artifactStoreBuilder.build();
    }

    public static ArtifactStoreUnmarshaller getInstance() {
        return INSTANCE;
    }
}

