/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.JobData;
import software.amazon.awssdk.services.codepipeline.transform.JobMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Job
implements StructuredPojo,
ToCopyableBuilder<Builder, Job> {
    private final String id;
    private final JobData data;
    private final String nonce;
    private final String accountId;

    private Job(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
        this.nonce = builder.nonce;
        this.accountId = builder.accountId;
    }

    public String id() {
        return this.id;
    }

    public JobData data() {
        return this.data;
    }

    public String nonce() {
        return this.nonce;
    }

    public String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.nonce(), other.nonce()) && Objects.equals(this.accountId(), other.accountId());
    }

    public String toString() {
        return ToString.builder((String)"Job").add("Id", (Object)this.id()).add("Data", (Object)this.data()).add("Nonce", (Object)this.nonce()).add("AccountId", (Object)this.accountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "nonce": {
                return Optional.of(clazz.cast(this.nonce()));
            }
            case "accountId": {
                return Optional.of(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private JobData data;
        private String nonce;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(Job model) {
            this.id(model.id);
            this.data(model.data);
            this.nonce(model.nonce);
            this.accountId(model.accountId);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final JobData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        @Override
        public final Builder data(JobData data) {
            this.data = data;
            return this;
        }

        public final void setData(JobData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        public final String getNonce() {
            return this.nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Job build() {
            return new Job(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Job> {
        public Builder id(String var1);

        public Builder data(JobData var1);

        default public Builder data(Consumer<JobData.Builder> data) {
            return this.data((JobData)((JobData.Builder)JobData.builder().apply(data)).build());
        }

        public Builder nonce(String var1);

        public Builder accountId(String var1);
    }
}

