/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.model.ArtifactStore;
import software.amazon.awssdk.services.codepipeline.model.PipelineStageDeclarationListCopier;
import software.amazon.awssdk.services.codepipeline.model.StageDeclaration;
import software.amazon.awssdk.services.codepipeline.transform.PipelineDeclarationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PipelineDeclaration
implements StructuredPojo,
ToCopyableBuilder<Builder, PipelineDeclaration> {
    private final String name;
    private final String roleArn;
    private final ArtifactStore artifactStore;
    private final List<StageDeclaration> stages;
    private final Integer version;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.stages = builder.stages;
        this.version = builder.version;
    }

    public String name() {
        return this.name;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public ArtifactStore artifactStore() {
        return this.artifactStore;
    }

    public List<StageDeclaration> stages() {
        return this.stages;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.stages());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.artifactStore(), other.artifactStore()) && Objects.equals(this.stages(), other.stages()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.artifactStore() != null) {
            sb.append("ArtifactStore: ").append(this.artifactStore()).append(",");
        }
        if (this.stages() != null) {
            sb.append("Stages: ").append(this.stages()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "artifactStore": {
                return Optional.of(clazz.cast(this.artifactStore()));
            }
            case "stages": {
                return Optional.of(clazz.cast(this.stages()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineDeclarationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String roleArn;
        private ArtifactStore artifactStore;
        private List<StageDeclaration> stages;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.artifactStore(model.artifactStore);
            this.stages(model.stages);
            this.version(model.version);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ArtifactStore.Builder getArtifactStore() {
            return this.artifactStore != null ? this.artifactStore.toBuilder() : null;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final void setArtifactStore(ArtifactStore.BuilderImpl artifactStore) {
            this.artifactStore = artifactStore != null ? artifactStore.build() : null;
        }

        public final Collection<StageDeclaration.Builder> getStages() {
            return this.stages != null ? (Collection)this.stages.stream().map(StageDeclaration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        public final void setStages(Collection<StageDeclaration.BuilderImpl> stages) {
            this.stages = PipelineStageDeclarationListCopier.copyFromBuilder(stages);
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PipelineDeclaration> {
        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder artifactStore(ArtifactStore var1);

        default public Builder artifactStore(Consumer<ArtifactStore.Builder> artifactStore) {
            return this.artifactStore((ArtifactStore)((ArtifactStore.Builder)ArtifactStore.builder().apply(artifactStore)).build());
        }

        public Builder stages(Collection<StageDeclaration> var1);

        public Builder stages(StageDeclaration ... var1);

        public Builder version(Integer var1);
    }
}

