/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecution;

@SdkInternalApi
public class PipelineExecutionMarshaller {
    private static final MarshallingInfo<String> PIPELINENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineName").build();
    private static final MarshallingInfo<Integer> PIPELINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineVersion").build();
    private static final MarshallingInfo<String> PIPELINEEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("pipelineExecutionId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<List> ARTIFACTREVISIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactRevisions").build();
    private static final PipelineExecutionMarshaller INSTANCE = new PipelineExecutionMarshaller();

    public static PipelineExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PipelineExecution pipelineExecution, ProtocolMarshaller protocolMarshaller) {
        if (pipelineExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)pipelineExecution.pipelineName(), PIPELINENAME_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecution.pipelineVersion(), PIPELINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecution.pipelineExecutionId(), PIPELINEEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)pipelineExecution.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall(pipelineExecution.artifactRevisions(), ARTIFACTREVISIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

