/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPipelineExecutionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPipelineExecutionsResponse> {
    private final List<PipelineExecutionSummary> pipelineExecutionSummaries;
    private final String nextToken;

    private ListPipelineExecutionsResponse(BuilderImpl builder) {
        this.pipelineExecutionSummaries = builder.pipelineExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<PipelineExecutionSummary> pipelineExecutionSummaries() {
        return this.pipelineExecutionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionsResponse)) {
            return false;
        }
        ListPipelineExecutionsResponse other = (ListPipelineExecutionsResponse)((Object)obj);
        return Objects.equals(this.pipelineExecutionSummaries(), other.pipelineExecutionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineExecutionSummaries() != null) {
            sb.append("PipelineExecutionSummaries: ").append(this.pipelineExecutionSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionSummaries": {
                return Optional.of(clazz.cast(this.pipelineExecutionSummaries()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<PipelineExecutionSummary> pipelineExecutionSummaries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionsResponse model) {
            this.pipelineExecutionSummaries(model.pipelineExecutionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<PipelineExecutionSummary.Builder> getPipelineExecutionSummaries() {
            return this.pipelineExecutionSummaries != null ? (Collection)this.pipelineExecutionSummaries.stream().map(PipelineExecutionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copy(pipelineExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(PipelineExecutionSummary ... pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries(Arrays.asList(pipelineExecutionSummaries));
            return this;
        }

        public final void setPipelineExecutionSummaries(Collection<PipelineExecutionSummary.BuilderImpl> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copyFromBuilder(pipelineExecutionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListPipelineExecutionsResponse build() {
            return new ListPipelineExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPipelineExecutionsResponse> {
        public Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> var1);

        public Builder pipelineExecutionSummaries(PipelineExecutionSummary ... var1);

        public Builder nextToken(String var1);
    }
}

