/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codepipeline.model.StageState;
import software.amazon.awssdk.services.codepipeline.model.StageStateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPipelineStateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetPipelineStateResponse> {
    private final String pipelineName;
    private final Integer pipelineVersion;
    private final List<StageState> stageStates;
    private final Instant created;
    private final Instant updated;

    private GetPipelineStateResponse(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageStates = builder.stageStates;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public List<StageState> stageStates() {
        return this.stageStates;
    }

    public Instant created() {
        return this.created;
    }

    public Instant updated() {
        return this.updated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageStates());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.updated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPipelineStateResponse)) {
            return false;
        }
        GetPipelineStateResponse other = (GetPipelineStateResponse)((Object)obj);
        return Objects.equals(this.pipelineName(), other.pipelineName()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.stageStates(), other.stageStates()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.updated(), other.updated());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.pipelineVersion() != null) {
            sb.append("PipelineVersion: ").append(this.pipelineVersion()).append(",");
        }
        if (this.stageStates() != null) {
            sb.append("StageStates: ").append(this.stageStates()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.updated() != null) {
            sb.append("Updated: ").append(this.updated()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "pipelineVersion": {
                return Optional.of(clazz.cast(this.pipelineVersion()));
            }
            case "stageStates": {
                return Optional.of(clazz.cast(this.stageStates()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "updated": {
                return Optional.of(clazz.cast(this.updated()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private Integer pipelineVersion;
        private List<StageState> stageStates;
        private Instant created;
        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPipelineStateResponse model) {
            this.pipelineName(model.pipelineName);
            this.pipelineVersion(model.pipelineVersion);
            this.stageStates(model.stageStates);
            this.created(model.created);
            this.updated(model.updated);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final Collection<StageState.Builder> getStageStates() {
            return this.stageStates != null ? (Collection)this.stageStates.stream().map(StageState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stageStates(Collection<StageState> stageStates) {
            this.stageStates = StageStateListCopier.copy(stageStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageStates(StageState ... stageStates) {
            this.stageStates(Arrays.asList(stageStates));
            return this;
        }

        public final void setStageStates(Collection<StageState.BuilderImpl> stageStates) {
            this.stageStates = StageStateListCopier.copyFromBuilder(stageStates);
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getUpdated() {
            return this.updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        public GetPipelineStateResponse build() {
            return new GetPipelineStateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetPipelineStateResponse> {
        public Builder pipelineName(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder stageStates(Collection<StageState> var1);

        public Builder stageStates(StageState ... var1);

        public Builder created(Instant var1);

        public Builder updated(Instant var1);
    }
}

