/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ArtifactRevisionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ArtifactRevision
implements StructuredPojo,
ToCopyableBuilder<Builder, ArtifactRevision> {
    private final String name;
    private final String revisionId;
    private final String revisionChangeIdentifier;
    private final String revisionSummary;
    private final Instant created;
    private final String revisionUrl;

    private ArtifactRevision(BuilderImpl builder) {
        this.name = builder.name;
        this.revisionId = builder.revisionId;
        this.revisionChangeIdentifier = builder.revisionChangeIdentifier;
        this.revisionSummary = builder.revisionSummary;
        this.created = builder.created;
        this.revisionUrl = builder.revisionUrl;
    }

    public String name() {
        return this.name;
    }

    public String revisionId() {
        return this.revisionId;
    }

    public String revisionChangeIdentifier() {
        return this.revisionChangeIdentifier;
    }

    public String revisionSummary() {
        return this.revisionSummary;
    }

    public Instant created() {
        return this.created;
    }

    public String revisionUrl() {
        return this.revisionUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionChangeIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactRevision)) {
            return false;
        }
        ArtifactRevision other = (ArtifactRevision)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.revisionChangeIdentifier(), other.revisionChangeIdentifier()) && Objects.equals(this.revisionSummary(), other.revisionSummary()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.revisionUrl(), other.revisionUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.revisionId() != null) {
            sb.append("RevisionId: ").append(this.revisionId()).append(",");
        }
        if (this.revisionChangeIdentifier() != null) {
            sb.append("RevisionChangeIdentifier: ").append(this.revisionChangeIdentifier()).append(",");
        }
        if (this.revisionSummary() != null) {
            sb.append("RevisionSummary: ").append(this.revisionSummary()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.revisionUrl() != null) {
            sb.append("RevisionUrl: ").append(this.revisionUrl()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "revisionId": {
                return Optional.of(clazz.cast(this.revisionId()));
            }
            case "revisionChangeIdentifier": {
                return Optional.of(clazz.cast(this.revisionChangeIdentifier()));
            }
            case "revisionSummary": {
                return Optional.of(clazz.cast(this.revisionSummary()));
            }
            case "created": {
                return Optional.of(clazz.cast(this.created()));
            }
            case "revisionUrl": {
                return Optional.of(clazz.cast(this.revisionUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ArtifactRevisionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String revisionId;
        private String revisionChangeIdentifier;
        private String revisionSummary;
        private Instant created;
        private String revisionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactRevision model) {
            this.name(model.name);
            this.revisionId(model.revisionId);
            this.revisionChangeIdentifier(model.revisionChangeIdentifier);
            this.revisionSummary(model.revisionSummary);
            this.created(model.created);
            this.revisionUrl(model.revisionUrl);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRevisionChangeIdentifier() {
            return this.revisionChangeIdentifier;
        }

        @Override
        public final Builder revisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
            return this;
        }

        public final void setRevisionChangeIdentifier(String revisionChangeIdentifier) {
            this.revisionChangeIdentifier = revisionChangeIdentifier;
        }

        public final String getRevisionSummary() {
            return this.revisionSummary;
        }

        @Override
        public final Builder revisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
            return this;
        }

        public final void setRevisionSummary(String revisionSummary) {
            this.revisionSummary = revisionSummary;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getRevisionUrl() {
            return this.revisionUrl;
        }

        @Override
        public final Builder revisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
            return this;
        }

        public final void setRevisionUrl(String revisionUrl) {
            this.revisionUrl = revisionUrl;
        }

        public ArtifactRevision build() {
            return new ArtifactRevision(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ArtifactRevision> {
        public Builder name(String var1);

        public Builder revisionId(String var1);

        public Builder revisionChangeIdentifier(String var1);

        public Builder revisionSummary(String var1);

        public Builder created(Instant var1);

        public Builder revisionUrl(String var1);
    }
}

