/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation;

@SdkInternalApi
public class S3ArtifactLocationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucketName").build();
    private static final MarshallingInfo<String> OBJECTKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("objectKey").build();
    private static final S3ArtifactLocationMarshaller INSTANCE = new S3ArtifactLocationMarshaller();

    public static S3ArtifactLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(S3ArtifactLocation s3ArtifactLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3ArtifactLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ArtifactLocation.bucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3ArtifactLocation.objectKey(), OBJECTKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

