/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codepipeline.transform.ThirdPartyJobMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ThirdPartyJob
implements StructuredPojo,
ToCopyableBuilder<Builder, ThirdPartyJob> {
    private final String clientId;
    private final String jobId;

    private ThirdPartyJob(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.jobId = builder.jobId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String jobId() {
        return this.jobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientId() == null ? 0 : this.clientId().hashCode());
        hashCode = 31 * hashCode + (this.jobId() == null ? 0 : this.jobId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThirdPartyJob)) {
            return false;
        }
        ThirdPartyJob other = (ThirdPartyJob)obj;
        if (other.clientId() == null ^ this.clientId() == null) {
            return false;
        }
        if (other.clientId() != null && !other.clientId().equals(this.clientId())) {
            return false;
        }
        if (other.jobId() == null ^ this.jobId() == null) {
            return false;
        }
        return other.jobId() == null || other.jobId().equals(this.jobId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clientId() != null) {
            sb.append("ClientId: ").append(this.clientId()).append(",");
        }
        if (this.jobId() != null) {
            sb.append("JobId: ").append(this.jobId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.of(clazz.cast(this.clientId()));
            }
            case "jobId": {
                return Optional.of(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ThirdPartyJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(ThirdPartyJob model) {
            this.clientId(model.clientId);
            this.jobId(model.jobId);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public ThirdPartyJob build() {
            return new ThirdPartyJob(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ThirdPartyJob> {
        public Builder clientId(String var1);

        public Builder jobId(String var1);
    }
}

