/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codepipeline.model.StageRetryMode;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RetryStageExecutionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RetryStageExecutionRequest> {
    private final String pipelineName;
    private final String stageName;
    private final String pipelineExecutionId;
    private final String retryMode;

    private RetryStageExecutionRequest(BuilderImpl builder) {
        this.pipelineName = builder.pipelineName;
        this.stageName = builder.stageName;
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.retryMode = builder.retryMode;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String stageName() {
        return this.stageName;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public StageRetryMode retryMode() {
        return StageRetryMode.fromValue(this.retryMode);
    }

    public String retryModeString() {
        return this.retryMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.pipelineName() == null ? 0 : this.pipelineName().hashCode());
        hashCode = 31 * hashCode + (this.stageName() == null ? 0 : this.stageName().hashCode());
        hashCode = 31 * hashCode + (this.pipelineExecutionId() == null ? 0 : this.pipelineExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.retryModeString() == null ? 0 : this.retryModeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetryStageExecutionRequest)) {
            return false;
        }
        RetryStageExecutionRequest other = (RetryStageExecutionRequest)((Object)obj);
        if (other.pipelineName() == null ^ this.pipelineName() == null) {
            return false;
        }
        if (other.pipelineName() != null && !other.pipelineName().equals(this.pipelineName())) {
            return false;
        }
        if (other.stageName() == null ^ this.stageName() == null) {
            return false;
        }
        if (other.stageName() != null && !other.stageName().equals(this.stageName())) {
            return false;
        }
        if (other.pipelineExecutionId() == null ^ this.pipelineExecutionId() == null) {
            return false;
        }
        if (other.pipelineExecutionId() != null && !other.pipelineExecutionId().equals(this.pipelineExecutionId())) {
            return false;
        }
        if (other.retryModeString() == null ^ this.retryModeString() == null) {
            return false;
        }
        return other.retryModeString() == null || other.retryModeString().equals(this.retryModeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pipelineName() != null) {
            sb.append("PipelineName: ").append(this.pipelineName()).append(",");
        }
        if (this.stageName() != null) {
            sb.append("StageName: ").append(this.stageName()).append(",");
        }
        if (this.pipelineExecutionId() != null) {
            sb.append("PipelineExecutionId: ").append(this.pipelineExecutionId()).append(",");
        }
        if (this.retryModeString() != null) {
            sb.append("RetryMode: ").append(this.retryModeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineName": {
                return Optional.of(clazz.cast(this.pipelineName()));
            }
            case "stageName": {
                return Optional.of(clazz.cast(this.stageName()));
            }
            case "pipelineExecutionId": {
                return Optional.of(clazz.cast(this.pipelineExecutionId()));
            }
            case "retryMode": {
                return Optional.of(clazz.cast(this.retryModeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineName;
        private String stageName;
        private String pipelineExecutionId;
        private String retryMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RetryStageExecutionRequest model) {
            this.pipelineName(model.pipelineName);
            this.stageName(model.stageName);
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.retryMode(model.retryMode);
        }

        public final String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getRetryMode() {
            return this.retryMode;
        }

        @Override
        public final Builder retryMode(String retryMode) {
            this.retryMode = retryMode;
            return this;
        }

        @Override
        public final Builder retryMode(StageRetryMode retryMode) {
            this.retryMode(retryMode.toString());
            return this;
        }

        public final void setRetryMode(String retryMode) {
            this.retryMode = retryMode;
        }

        public RetryStageExecutionRequest build() {
            return new RetryStageExecutionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RetryStageExecutionRequest> {
        public Builder pipelineName(String var1);

        public Builder stageName(String var1);

        public Builder pipelineExecutionId(String var1);

        public Builder retryMode(String var1);

        public Builder retryMode(StageRetryMode var1);
    }
}

